%{
#include <stdio.h>
#include <conio.h>
#include <string.h>

int tmp;   
char comment[256];
char * text;    
char * character;
                                              
%}

%option noyywrap
%option never-interactive

DATATYPE integer|character|string

id [_a-zA-Z][_a-zA-Z0-9]*

%x COMMENT
%x STRING
%x CHARACTER

%%
{DATATYPE} printf("Type of data: %s\n", yytext);


class printf("Keyword: %s\n", yytext);

feature printf("Keyword: %s\n", yytext);

inherit printf("Keyword: %s\n", yytext);

put_string printf("Keyword: %s\n", yytext);

put_integer printf("Keyword: %s\n", yytext);

put_new_line printf("Keyword: %s\n", yytext);

until printf("Keyword: %s\n", yytext);

loop printf("Keyword: %s\n", yytext);

invariant printf("Keyword: %s\n", yytext);

variant printf("Keyword: %s\n", yytext);

from printf("Keyword: %s\n", yytext);

inspect printf("Keyword: %s\n", yytext);

then printf("Keyword: %s\n", yytext);

when printf("Keyword: %s\n", yytext);

do printf("Keyword: %s\n", yytext);

is printf("Keyword: %s\n", yytext);

local printf("Keyword: %s\n", yytext);

end printf("Keyword: %s\n", yytext);

elseif printf("Keyword: %s\n", yytext);

if printf("Keyword: %s\n", yytext);

else printf("Keyword: %s\n", yytext);

array printf("Keyword: %s\n", yytext);

result printf("Keyword: %s\n", yytext);

public printf("Keyword: %s\n", yytext);

private printf("Keyword: %s\n", yytext);

protected printf("Keyword: %s\n", yytext);

or printf("Keyword: %s\n", yytext);

and printf("Keyword: %s\n", yytext);

not printf("Keyword: %s\n", yytext);

xor printf("Keyword: %s\n", yytext);

implies printf("Keyword: %s\n", yytext);

true printf("Keyword: %s\n", yytext);

false printf("Keyword: %s\n", yytext);

not	printf("Keyword: %s\n", yytext);

io printf("Keyword: %s\n", yytext);

"+"	printf( "Operator: %s\n", yytext );

"-"	printf( "Operator: %s\n", yytext );	

"*"	printf( "Operator: %s\n", yytext );

"/"	printf( "Operator: %s\n", yytext );

"//"	printf( "Operator: %s\n", yytext );

"\\"	printf( "Operator: %s\n", yytext );

"="	printf( "Operator: %s\n", yytext );

"/=" printf( "Operator: %s\n", yytext );

">" printf( "Operator: %s\n", yytext );
	
">=" printf( "Operator: %s\n", yytext );

"<" printf( "Operator: %s\n", yytext );

"<=" printf( "Operator: %s\n", yytext ); 

"^" printf( "Operator: %s\n", yytext );

":=" printf( "Operator: %s\n", yytext );

"[" printf( "Operator: %s\n", yytext );

"]"	printf( "Operator: %s\n", yytext );

"(" printf( "Operator: %s\n", yytext );

")" printf( "Operator: %s\n", yytext );

"{" printf( "Operator: %s\n", yytext );

"}" printf( "Operator: %s\n", yytext );

"~" printf( "Operator: %s\n", yytext );

":" printf( "Operator: %s\n", yytext );

"," printf( "Operator: %s\n", yytext );

";" printf( "Operator: %s\n", yytext );

"." printf( "Operator: %s\n", yytext );

-?[0-9]+ printf("Decimal constant : %d\n", yytext);

0[0-7]+ {sscanf (yytext, "%o", &tmp);	
                 printf("Octal constant : %o\n", tmp);
}

0x[0-9a-f]+|0X[0-9A-F]+ {sscanf(yytext, "%x", &tmp);
	                    printf("Hexadecimal constant: %x \n", tmp);
}

{id} {text = (char*)malloc(yyleng);
	  strcpy(text, yytext);
	  printf("Identifier: %s\n", text);
}

"--" BEGIN(COMMENT); 
	<COMMENT>.* {strcat(comment, yytext); 
	printf("The one-line comment: %s\n", comment );
	comment[0] = 0;
	BEGIN(INITIAL);
}

"'" { BEGIN (CHARACTER);
	  character = (char*)malloc(yyleng);
      character[0] = 0;}
<CHARACTER>[^%%'%%] strcat (character, yytext);
<CHARACTER>%' strcat(character, "'");
<CHARACTER>%% strcat(character, "%%");
<CHARACTER>%A strcat(character, "\@");
<CHARACTER>%B strcat(character, "BS");
<CHARACTER>%C strcat(character, "\^");
<CHARACTER>%D strcat(character, "\$");
<CHARACTER>%F strcat(character, "FF");
<CHARACTER>%H strcat(character, "\\");
<CHARACTER>%L strcat(character, "\~");
<CHARACTER>%N strcat(character, "NL");
<CHARACTER>%Q strcat(character, "\`");
<CHARACTER>%R strcat(character, "CR");
<CHARACTER>%S strcat(character, "\#");
<CHARACTER>%T strcat(character, "HT");
<CHARACTER>%U strcat(character, "NUL");
<CHARACTER>%V strcat(character, "\|");
<CHARACTER>%" strcat(character, "\"");
<CHARACTER>%[ strcat(character, "\[");
<CHARACTER>%] strcat(character, "\]");
<CHARACTER>%{ strcat(character, "\{");
<CHARACTER>%} strcat(character, "\}");

<CHARACTER>"'"  {printf ("Character: %s\n", character);
BEGIN (INITIAL);}	  



%%
void main(int argc, char* argv[])
{
    
    yyin = fopen("test.txt", "r");
   
	yylex();
	
	getch();

}