/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.eclipseplugin.tools;

import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.product.diagram.classes.ClassNode;
import com.horstmann.violet.product.diagram.sequence.LifelineNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.util.JavaParser;

public class JavaFileModel {
    private String className;
    private String[] classMethods;
    private String[] classAttributes;

    public JavaFileModel(File pFile) {
        ArrayList<String> methodsArray = new ArrayList<String>();
        ArrayList<String> attributsArray = new ArrayList<String>();
        try {
            JavaSourceFactory jsf = new JavaSourceFactory();
            JavaParser jp = new JavaParser(jsf);
            jp.parse(pFile);
            Iterator iter = jsf.getJavaSources();
            if (iter.hasNext()) {
                JavaSource js = (JavaSource)iter.next();
                this.setClassName(js.getClassName());
                JavaMethod[] methods = js.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    methodsArray.add(methods[i].getName());
                }
                this.setClassMethods(methodsArray.toArray(new String[methodsArray.size()]));
                JavaField[] attributs = js.getFields();
                for (int i = 0; i < attributs.length; ++i) {
                    attributsArray.add(attributs[i].getName());
                }
                this.setClassAttributes(attributsArray.toArray(new String[attributsArray.size()]));
            }
        }
        catch (Exception e) {
            this.setClassName("");
            this.setClassAttributes(new String[]{""});
            this.setClassMethods(new String[]{""});
            e.printStackTrace();
        }
    }

    public String[] getClassAttributes() {
        return this.classAttributes;
    }

    public void setClassAttributes(String[] classAttributes) {
        this.classAttributes = classAttributes;
    }

    public String[] getClassMethods() {
        return this.classMethods;
    }

    public void setClassMethods(String[] classMethods) {
        this.classMethods = classMethods;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public LifelineNode getLifelineNode() {
        MultiLineString mls = new MultiLineString();
        mls.setText(this.getClassName());
        LifelineNode seqNode = new LifelineNode();
        seqNode.setName(mls);
        return seqNode;
    }

    public ClassNode getClassNode() {
        int i;
        ClassNode classNode = new ClassNode();
        MultiLineString mls = new MultiLineString();
        StringBuffer text = new StringBuffer();
        for (i = 0; i < this.getClassMethods().length; ++i) {
            text.append(this.getClassMethods()[i]);
            text.append("\n");
        }
        mls.setText(text.toString());
        mls.setJustification(0);
        classNode.setMethods(mls);
        mls = new MultiLineString();
        text = new StringBuffer();
        for (i = 0; i < this.getClassAttributes().length; ++i) {
            text.append(this.getClassAttributes()[i]);
            text.append("\n");
        }
        mls.setText(text.toString());
        mls.setJustification(0);
        classNode.setAttributes(mls);
        mls = new MultiLineString();
        mls.setText(this.getClassName());
        mls.setSize(3);
        classNode.setName(mls);
        return classNode;
    }
}

