/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.action;

import com.horstmann.violet.UMLEditor;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.GraphService;
import com.horstmann.violet.framework.file.ExtensionFilter;
import com.horstmann.violet.framework.file.FileChooserService;
import com.horstmann.violet.framework.file.FileOpenerHandler;
import com.horstmann.violet.framework.file.FileSaverHandler;
import com.horstmann.violet.framework.file.FileService;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.DialogFactory;
import com.horstmann.violet.framework.gui.EditorFrame;
import com.horstmann.violet.framework.gui.PrintPanel;
import com.horstmann.violet.framework.gui.menu.FileMenu;
import com.horstmann.violet.framework.network.NetworkAction;
import com.horstmann.violet.product.diagram.classes.ClassDiagramGraph;
import java.awt.Component;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;

public class FileAction {
    private ResourceBundle menuResourceBundle = ResourceBundle.getBundle("properties.MenuStrings", Locale.getDefault());

    public void open(FileMenu menu, FileChooserService fileChooserService, EditorFrame editorFrame) {
        try {
            FileOpenerHandler open = fileChooserService.open(null, null, FileService.getFileFilters());
            InputStream in = open.getInputStream();
            if (in != null) {
                Graph graph = GraphService.readGraph(in);
                DiagramPanel frame = new DiagramPanel(graph);
                editorFrame.addTabbedPane(frame);
                frame.setFilePath(open.getName());
                menu.addRecentFile(open.getName());
                FileService.addOpenedFile(open.getName());
            }
        }
        catch (IOException e) {
            DialogFactory.getInstance().showErrorDialog(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void openRemoteFile(FileMenu menu, EditorFrame editorFrame) {
        NetworkAction action = new NetworkAction();
        action.openRemoteDiagram();
    }

    public void openURL(URL url, EditorFrame editorFrame) {
        try {
            InputStream in = url.openStream();
            if (in != null) {
                Graph graph = GraphService.readGraph(in);
                DiagramPanel frame = new DiagramPanel(graph);
                editorFrame.addTabbedPane(frame);
            }
        }
        catch (IOException e) {
            DialogFactory.getInstance().showErrorDialog(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void open(String path, EditorFrame editorFrame) {
        try {
            Graph graph = GraphService.readGraph(new FileInputStream(path));
            if (graph == null) {
                return;
            }
            DiagramPanel frame = new DiagramPanel(graph);
            editorFrame.addTabbedPane(frame);
            frame.setFilePath(path);
            FileService.addOpenedFile(path);
        }
        catch (Exception e) {
            DialogFactory.getInstance().showErrorDialog(e.getMessage());
        }
    }

    public void open(String[] filePaths, EditorFrame editorFrame) {
        for (int i = 0; i < filePaths.length; ++i) {
            String aPath = filePaths[i];
            this.open(aPath, editorFrame);
        }
    }

    public void close(FileMenu menu, EditorFrame editorFrame, DiagramPanel diagramPanel, FileChooserService fileChooserService) {
        if (diagramPanel.isSaveNeeded()) {
            String message = this.menuResourceBundle.getString("dialog.close.ok");
            String title = this.menuResourceBundle.getString("dialog.close.title");
            ImageIcon icon = new ImageIcon(this.getClass().getResource(this.menuResourceBundle.getString("dialog.close.icon")));
            JOptionPane optionPane = new JOptionPane();
            optionPane.setMessage(message);
            optionPane.setOptionType(1);
            optionPane.setIcon(icon);
            DialogFactory.getInstance().showDialog(optionPane, title, true);
            int result = 2;
            if (!JOptionPane.UNINITIALIZED_VALUE.equals(optionPane.getValue())) {
                result = (Integer)optionPane.getValue();
            }
            if (result == 0) {
                this.save(menu, diagramPanel, fileChooserService);
                editorFrame.removeDiagramPanel(diagramPanel);
                FileService.removeOpenedFile(diagramPanel.getFilePath());
            }
            if (result == 1) {
                editorFrame.removeDiagramPanel(diagramPanel);
                FileService.removeOpenedFile(diagramPanel.getFilePath());
            }
        }
        if (!diagramPanel.isSaveNeeded()) {
            editorFrame.removeDiagramPanel(diagramPanel);
            FileService.removeOpenedFile(diagramPanel.getFilePath());
        }
    }

    public void save(FileMenu menu, DiagramPanel diagramPanel, FileChooserService fileChooserService) {
        if (diagramPanel == null) {
            return;
        }
        String fileName = diagramPanel.getFilePath();
        if (fileName == null) {
            this.saveAs(menu, diagramPanel, fileChooserService);
            return;
        }
        try {
            Graph g = diagramPanel.getGraphPanel().getGraph();
            GraphService.write(g, (OutputStream)new FileOutputStream(fileName));
            diagramPanel.setSaveNeeded(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(FileMenu menu, DiagramPanel diagramPanel, FileChooserService fileChooserService) {
        block6: {
            if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
                return;
            }
            try {
                ExtensionFilter extensionFilter = FileService.getExtensionFilter(diagramPanel.getGraphPanel().getGraph());
                FileSaverHandler save = fileChooserService.save(null, diagramPanel.getFilePath(), extensionFilter, null, extensionFilter.getExtensions()[0]);
                OutputStream out = save.getOutputStream();
                if (out == null) break block6;
                try {
                    Graph g = diagramPanel.getGraphPanel().getGraph();
                    GraphService.write(g, out);
                    diagramPanel.setSaveNeeded(false);
                }
                finally {
                    out.close();
                }
                diagramPanel.setFilePath(save.getName());
                menu.addRecentFile(save.getName());
                FileService.addOpenedFile(save.getName());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportImage(DiagramPanel diagramPanel, FileChooserService fileChooserService) {
        block10: {
            if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
                return;
            }
            try {
                String format;
                String imageExtensions = FileService.getImageFileExtension();
                ExtensionFilter extensionFilter = FileService.getExtensionFilter(diagramPanel.getGraphPanel().getGraph());
                ExtensionFilter exportFilter = FileService.getImageExtensionFilter();
                FileSaverHandler save = fileChooserService.save(null, diagramPanel.getFilePath(), exportFilter, extensionFilter.getExtensions()[0], imageExtensions);
                OutputStream out = save.getOutputStream();
                if (out == null) break block10;
                String fileName = save.getName();
                if (fileName == null) {
                    int n = imageExtensions.indexOf("|");
                    if (n < 0) {
                        n = imageExtensions.length();
                    }
                    format = imageExtensions.substring(1, n);
                } else {
                    format = fileName.substring(fileName.lastIndexOf(".") + 1);
                }
                if (!ImageIO.getImageWritersByFormatName(format).hasNext()) {
                    MessageFormat formatter = new MessageFormat(this.menuResourceBundle.getString("dialog.error.unsupported_image"));
                    String message = formatter.format(new Object[]{format});
                    String title = this.menuResourceBundle.getString("dialog.error.title");
                    JOptionPane optionPane = new JOptionPane();
                    optionPane.setMessage(message);
                    DialogFactory.getInstance().showDialog(optionPane, title, true);
                    return;
                }
                Graph graph = diagramPanel.getGraphPanel().getGraph();
                try {
                    ImageIO.write((RenderedImage)GraphService.getImage(graph), format, out);
                }
                finally {
                    out.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void exportToClipboard(DiagramPanel diagramPanel) {
        if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
            return;
        }
        Graph graph = diagramPanel.getGraphPanel().getGraph();
        GraphService.exportToclipBoard(graph);
        ImageIcon icon = new ImageIcon(this.getClass().getResource(this.menuResourceBundle.getString("dialog.export_to_clipboard.icon")));
        String message = this.menuResourceBundle.getString("dialog.export_to_clipboard.ok");
        String title = this.menuResourceBundle.getString("dialog.export_to_clipboard.title");
        JLabel label = new JLabel(message);
        label.setFont(label.getFont().deriveFont(0));
        JOptionPane optionPane = new JOptionPane();
        optionPane.setIcon(icon);
        optionPane.setMessage(label);
        optionPane.setName(title);
        DialogFactory.getInstance().showDialog(optionPane, title, true);
    }

    public void exportToXMI(DiagramPanel diagramPanel, FileChooserService fileChooserService) {
        if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
            return;
        }
        Graph graph = diagramPanel.getGraphPanel().getGraph();
        if (graph instanceof ClassDiagramGraph) {
            DialogFactory.getInstance().showErrorDialog(this.menuResourceBundle.getString("dialog.export_to_xmi.error"));
            return;
        }
        try {
            String xmiExtension = FileService.getXMIFileExtension();
            ExtensionFilter extensionFilter = FileService.getExtensionFilter(diagramPanel.getGraphPanel().getGraph());
            ExtensionFilter exportFilter = FileService.getXMIExtensionFilter();
            FileSaverHandler save = fileChooserService.save(null, diagramPanel.getFilePath(), exportFilter, extensionFilter.getExtensions()[0], xmiExtension);
            OutputStream out = save.getOutputStream();
            if (out != null) {
                GraphService.exportToXMI(graph, out);
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void print(DiagramPanel diagramPanel) {
        if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
            return;
        }
        PrintPanel printPanel = new PrintPanel(diagramPanel.getGraphPanel().getGraph());
        JOptionPane optionPane = new JOptionPane();
        ResourceBundle printBundle = ResourceBundle.getBundle("properties.PrintStrings", Locale.getDefault());
        String printCloseText = printBundle.getString("dialog.print.cancel.text");
        optionPane.setOptions(new String[]{printCloseText});
        optionPane.setMessage(printPanel);
        optionPane.setBorder(new EmptyBorder(0, 0, 10, 0));
        DialogFactory.getInstance().showDialog(optionPane, "Print", true);
    }

    public void exit(FileMenu menu, EditorFrame editorFrame, FileChooserService fileChooserService) {
        boolean ok = this.isItReadyToExit(menu, editorFrame, fileChooserService);
        if (ok) {
            UMLEditor.getInstance().exit();
        }
    }

    public void restart(FileMenu menu, EditorFrame editorFrame, FileChooserService fileChooserService) {
        boolean ok = this.isItReadyToExit(menu, editorFrame, fileChooserService);
        if (ok) {
            UMLEditor.getInstance().restart();
        }
    }

    private boolean isItReadyToExit(FileMenu menu, EditorFrame editorFrame, FileChooserService fileChooserService) {
        ArrayList<DiagramPanel> unsavedDiagram = new ArrayList<DiagramPanel>();
        Component[] diagramPanels = editorFrame.getTabbedPane().getComponents();
        for (int i = 0; i < diagramPanels.length; ++i) {
            DiagramPanel aDiagramPanel;
            if (!(diagramPanels[i] instanceof DiagramPanel) || !(aDiagramPanel = (DiagramPanel)diagramPanels[i]).isSaveNeeded()) continue;
            unsavedDiagram.add(aDiagramPanel);
        }
        int unsavedCount = unsavedDiagram.size();
        DiagramPanel activeDiagramPanel = editorFrame.getActiveDiagramPanel();
        if (unsavedCount > 0) {
            ImageIcon icon = new ImageIcon(this.getClass().getResource(this.menuResourceBundle.getString("dialog.exit.icon")));
            String message = MessageFormat.format(this.menuResourceBundle.getString("dialog.exit.ok"), new Integer(unsavedCount));
            String title = this.menuResourceBundle.getString("dialog.exit.title");
            JOptionPane optionPane = new JOptionPane(message, -1, 1, icon);
            DialogFactory.getInstance().showDialog(optionPane, title, true);
            int result = 0;
            if (!JOptionPane.UNINITIALIZED_VALUE.equals(optionPane.getValue())) {
                result = (Integer)optionPane.getValue();
            }
            if (result == 2) {
                return false;
            }
            if (result == 0) {
                for (DiagramPanel anUnsavedDiagram : unsavedDiagram) {
                    this.save(menu, anUnsavedDiagram, fileChooserService);
                }
                FileService.updateRecentFiles(menu.getRecentFiles());
                FileService.setActiveDiagramFile(activeDiagramPanel.getFilePath());
                return true;
            }
            if (result == 1) {
                FileService.updateRecentFiles(menu.getRecentFiles());
                FileService.setActiveDiagramFile(activeDiagramPanel.getFilePath());
                return true;
            }
        }
        if (unsavedCount == 0) {
            FileService.updateRecentFiles(menu.getRecentFiles());
            if (activeDiagramPanel != null) {
                FileService.setActiveDiagramFile(activeDiagramPanel.getFilePath());
            }
            return true;
        }
        return false;
    }

    public void createDiagram(Class<? extends Graph> graphClass, EditorFrame editorFrame) {
        try {
            DiagramPanel frame = new DiagramPanel(graphClass.newInstance());
            editorFrame.addTabbedPane(frame);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

