/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import java.awt.geom.Point2D;

public class Direction {
    private double x;
    private double y;
    public static final Direction NORTH = new Direction(0.0, -1.0);
    public static final Direction SOUTH = new Direction(0.0, 1.0);
    public static final Direction EAST = new Direction(1.0, 0.0);
    public static final Direction WEST = new Direction(-1.0, 0.0);

    public Direction(double dx, double dy) {
        this.x = dx;
        this.y = dy;
        double length = Math.sqrt(this.x * this.x + this.y * this.y);
        if (length == 0.0) {
            return;
        }
        this.x /= length;
        this.y /= length;
    }

    public Direction(Point2D p, Point2D q) {
        this(q.getX() - p.getX(), q.getY() - p.getY());
    }

    public Direction turn(double angle) {
        double a = Math.toRadians(angle);
        return new Direction(this.x * Math.cos(a) - this.y * Math.sin(a), this.x * Math.sin(a) + this.y * Math.cos(a));
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Direction getNearestCardinalDirection() {
        long privateX = Math.round(this.getX());
        long privateY = Math.round(this.getY());
        if (Math.abs(privateX) == 1L && Math.abs(privateY) == 1L) {
            if (Math.abs(this.getX()) >= Math.abs(this.getY())) {
                privateY = 0L;
            }
            if (Math.abs(this.getX()) < Math.abs(this.getY())) {
                privateX = 0L;
            }
        }
        if (privateX == 0L && privateY == -1L) {
            return NORTH;
        }
        if (privateX == 0L && privateY == 1L) {
            return SOUTH;
        }
        if (privateX == 1L && privateY == 0L) {
            return EAST;
        }
        if (privateX == -1L && privateY == 0L) {
            return WEST;
        }
        return this;
    }
}

