/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.Node;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class Clipboard
extends Graph {
    public void copyIn(Graph g, List<Node> selectedNodes) {
        if (selectedNodes.size() == 0) {
            return;
        }
        Rectangle2D bounds = null;
        for (Node n : selectedNodes) {
            if (bounds == null) {
                bounds = n.getBounds();
                continue;
            }
            bounds.add(n.getBounds());
        }
        HashSet<Node> includedNodes = new HashSet<Node>();
        for (Node n : selectedNodes) {
            Clipboard.addDependents(n, includedNodes);
        }
        ArrayList<Edge> edges = new ArrayList<Edge>(this.getEdges());
        for (Edge e : edges) {
            this.removeEdge(e);
        }
        ArrayList<Node> nodes = new ArrayList<Node>(this.getNodes());
        for (Node n : nodes) {
            this.removeNode(n);
        }
        Clipboard.copyStructure(g, includedNodes, this, null, -bounds.getX(), -bounds.getY());
    }

    private static void addDependents(Node n, Set<Node> dependents) {
        if (dependents.contains(n)) {
            return;
        }
        dependents.add(n);
        for (Node c : n.getChildren()) {
            Clipboard.addDependents(c, dependents);
        }
        try {
            for (PropertyDescriptor descriptor : Introspector.getBeanInfo(n.getClass()).getPropertyDescriptors()) {
                if (!Node.class.isAssignableFrom(descriptor.getPropertyType())) continue;
                Node value = (Node)descriptor.getReadMethod().invoke((Object)n, new Object[0]);
                Clipboard.addDependents(value, dependents);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Collection<Node> pasteOut(Graph g, Node selectedNode) {
        return Clipboard.copyStructure(this, this.getNodes(), g, selectedNode, 0.0, 0.0);
    }

    private static Collection<Node> copyStructure(Graph graphIn, Collection<Node> selectedIn, Graph graphOut, Node selectedOut, double dx, double dy) {
        Node[] nodeProtos = graphOut.getNodePrototypes();
        if (nodeProtos != null) {
            HashSet nodeClasses = new HashSet();
            for (Node n : nodeProtos) {
                nodeClasses.add(n.getClass());
            }
            for (Node n : selectedIn) {
                if (nodeClasses.contains(n.getClass())) continue;
                return null;
            }
        }
        LinkedHashMap<Node, Node> originalAndClonedNodes = new LinkedHashMap<Node, Node>();
        for (Node n : selectedIn) {
            Node n2 = n.clone();
            originalAndClonedNodes.put(n, n2);
        }
        ArrayList<Edge> newEdges = new ArrayList<Edge>();
        for (Edge e : graphIn.getEdges()) {
            Node start = null;
            Node end = null;
            start = (Node)originalAndClonedNodes.get(e.getStart());
            if (start == null || (end = (Node)originalAndClonedNodes.get(e.getEnd())) == null) continue;
            Edge e2 = e.clone();
            e2.connect(start, end);
            newEdges.add(e2);
        }
        Edge[] edgeProtos = graphOut.getEdgePrototypes();
        if (edgeProtos != null) {
            HashSet edgeClasses = new HashSet();
            for (Edge e : edgeProtos) {
                edgeClasses.add(e.getClass());
            }
            for (Edge e : newEdges) {
                if (edgeClasses.contains(e.getClass())) continue;
                return null;
            }
        }
        for (Node n : originalAndClonedNodes.values()) {
            Point2D location = n.getLocation();
            Point2D.Double p = new Point2D.Double(location.getX() + dx, location.getY() + dy);
            graphOut.addNode(n, p);
        }
        for (Edge e : newEdges) {
            graphOut.connect(e, e.getStart(), e.getEnd());
        }
        if (selectedOut != null) {
            selectedOut.checkPasteChildren(originalAndClonedNodes.values());
        }
        for (Node n : selectedIn) {
            for (Node child : n.getChildren()) {
                Node child2 = (Node)originalAndClonedNodes.get(child);
                if (child2 == null) continue;
                Node n2 = (Node)originalAndClonedNodes.get(n);
                n2.addChild(n2.getChildren().size(), child2);
            }
            try {
                for (PropertyDescriptor descriptor : Introspector.getBeanInfo(n.getClass()).getPropertyDescriptors()) {
                    Node value;
                    Node value2;
                    if (!Node.class.isAssignableFrom(descriptor.getPropertyType()) || (value2 = (Node)originalAndClonedNodes.get(value = (Node)descriptor.getReadMethod().invoke((Object)n, new Object[0]))) == null) continue;
                    Node n2 = (Node)originalAndClonedNodes.get(n);
                    descriptor.getWriteMethod().invoke((Object)n2, value2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return originalAndClonedNodes.values();
    }

    @Override
    public Node[] getNodePrototypes() {
        return null;
    }

    @Override
    public Edge[] getEdgePrototypes() {
        return null;
    }
}

