/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import com.horstmann.violet.UMLEditor;
import com.horstmann.violet.framework.diagram.DiagramLink;
import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.GraphModificationListener;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.DialogFactory;
import com.horstmann.violet.framework.gui.GraphPanelEventType;
import com.horstmann.violet.framework.gui.GraphPanelListener;
import com.horstmann.violet.framework.gui.GraphPanelSelectionHandler;
import com.horstmann.violet.framework.gui.PropertySheet;
import com.horstmann.violet.framework.gui.sidebar.SideToolPanel;
import com.horstmann.violet.framework.gui.sidebar.Tool;
import com.horstmann.violet.framework.util.PropertyUtils;
import com.horstmann.violet.product.diagram.common.DiagramLinkNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class GraphPanel
extends JPanel {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("properties.OtherStrings", Locale.getDefault());
    private SideToolPanel.Listener toolListener;
    private Graph graph;
    private Grid grid;
    private DiagramPanel diagramPanel;
    private double zoom;
    private double gridSize = 10.0;
    private boolean hideGrid;
    private Object selectedTool;
    private Point2D lastMousePoint;
    private Point2D mouseDownPoint;
    private int dragMode;
    private UndoManager undoManager = new UndoManager();
    private GraphPanelSelectionHandler selectionHandler = new GraphPanelSelectionHandler();
    private Vector<GraphPanelListener> listeners = new Vector();
    private CompoundEdit capturedEdit;
    private GraphModificationListener graphModListener;
    private static final int DRAG_NONE = 0;
    private static final int DRAG_MOVE = 1;
    private static final int DRAG_RUBBERBAND = 2;
    private static final int DRAG_LASSO = 3;
    private static final int GRID_SIZE = 10;
    private static final int CONNECT_THRESHOLD = 8;
    private static final Color PURPLE = new Color(0.7f, 0.4f, 0.7f);

    public GraphPanel(Graph aGraph) {
        this.graph = aGraph;
        this.zoom = 1.0;
        this.setBackground(Color.WHITE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                GraphPanel.this.requestFocus();
                Point2D.Double mousePoint = new Point2D.Double((double)event.getX() / GraphPanel.this.zoom, (double)event.getY() / GraphPanel.this.zoom);
                boolean isCtrl = (event.getModifiersEx() & 0x80) != 0;
                Node n = GraphPanel.this.graph.findNode(mousePoint);
                Edge e = GraphPanel.this.graph.findEdge(mousePoint);
                if (event.getClickCount() > 1 || (event.getModifiers() & 0x10) == 0) {
                    if (e != null) {
                        GraphPanel.this.selectionHandler.setSelectedElement(e);
                        GraphPanel.this.editSelected();
                        GraphPanel.this.fireEventHappenedOnEdge(GraphPanelEventType.EDGE_UDPATED, e);
                    } else if (n != null) {
                        GraphPanel.this.selectionHandler.setSelectedElement(n);
                        GraphPanel.this.editSelected();
                        GraphPanel.this.fireEventHappenedOnNode(GraphPanelEventType.NODE_UDPATED, n);
                    }
                } else if (GraphPanel.this.selectedTool == null) {
                    if (e != null) {
                        GraphPanel.this.selectionHandler.setSelectedElement(e);
                    } else if (n != null) {
                        if (isCtrl) {
                            GraphPanel.this.selectionHandler.addSelectedElement(n);
                        } else if (!GraphPanel.this.selectionHandler.isElementAlreadySelected(n)) {
                            GraphPanel.this.selectionHandler.setSelectedElement(n);
                        }
                        GraphPanel.this.dragMode = 1;
                    } else {
                        if (!isCtrl) {
                            GraphPanel.this.selectionHandler.clearSelection();
                        }
                        GraphPanel.this.dragMode = 3;
                    }
                } else if (GraphPanel.this.selectedTool instanceof Node) {
                    Node prototype = (Node)GraphPanel.this.selectedTool;
                    Node newNode = prototype.clone();
                    boolean added = GraphPanel.this.addNodeAtPoint(newNode, mousePoint);
                    if (added) {
                        GraphPanel.this.selectionHandler.setSelectedElement(newNode);
                        GraphPanel.this.dragMode = 1;
                    } else if (n != null) {
                        if (isCtrl) {
                            GraphPanel.this.selectionHandler.addSelectedElement(n);
                        } else if (!GraphPanel.this.selectionHandler.isElementAlreadySelected(n)) {
                            GraphPanel.this.selectionHandler.setSelectedElement(n);
                        }
                        GraphPanel.this.dragMode = 1;
                    }
                } else if (GraphPanel.this.selectedTool instanceof Edge && n != null) {
                    GraphPanel.this.dragMode = 2;
                }
                GraphPanel.this.lastMousePoint = mousePoint;
                GraphPanel.this.mouseDownPoint = mousePoint;
                GraphPanel.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                Point2D.Double mousePoint = new Point2D.Double((double)event.getX() / GraphPanel.this.zoom, (double)event.getY() / GraphPanel.this.zoom);
                if (GraphPanel.this.dragMode == 2) {
                    Edge prototype = (Edge)GraphPanel.this.selectedTool;
                    Edge newEdge = prototype.clone();
                    boolean added = GraphPanel.this.addEdgeAtPoints(newEdge, GraphPanel.this.mouseDownPoint, mousePoint);
                    if (added) {
                        GraphPanel.this.selectionHandler.setSelectedElement(newEdge);
                    }
                } else if (GraphPanel.this.dragMode == 1 && GraphPanel.this.capturedEdit != null) {
                    GraphPanel.this.graph.layout((Graphics2D)GraphPanel.this.getGraphics(), GraphPanel.this.grid);
                    GraphPanel.this.stopCaptureEdit();
                }
                GraphPanel.this.dragMode = 0;
                GraphPanel.this.revalidate();
                GraphPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent event) {
                Point2D.Double mousePoint = new Point2D.Double((double)event.getX() / GraphPanel.this.zoom, (double)event.getY() / GraphPanel.this.zoom);
                if (GraphPanel.this.dragMode == 1 && GraphPanel.this.selectionHandler.isNodeSelectedAtLeast()) {
                    if (GraphPanel.this.capturedEdit == null) {
                        GraphPanel.this.startCaptureEdit();
                    }
                    Node lastNode = GraphPanel.this.selectionHandler.getLastSelectedNode();
                    Rectangle2D bounds = lastNode.getBounds();
                    double dx = ((Point2D)mousePoint).getX() - GraphPanel.this.lastMousePoint.getX();
                    double dy = ((Point2D)mousePoint).getY() - GraphPanel.this.lastMousePoint.getY();
                    List<Node> selectedNodes = GraphPanel.this.selectionHandler.getSelectedNodes();
                    for (Node n : selectedNodes) {
                        bounds.add(n.getBounds());
                    }
                    dx = Math.max(dx, -bounds.getX());
                    dy = Math.max(dy, -bounds.getY());
                    for (Node n : selectedNodes) {
                        if (selectedNodes.contains(n.getParent())) continue;
                        n.translate(dx, dy);
                    }
                } else if (GraphPanel.this.dragMode == 3) {
                    boolean isCtrl = (event.getModifiersEx() & 0x80) != 0;
                    double x1 = GraphPanel.this.mouseDownPoint.getX();
                    double y1 = GraphPanel.this.mouseDownPoint.getY();
                    double x2 = ((Point2D)mousePoint).getX();
                    double y2 = ((Point2D)mousePoint).getY();
                    Rectangle2D.Double lasso = new Rectangle2D.Double(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1 - x2), Math.abs(y1 - y2));
                    for (Node n : GraphPanel.this.graph.getNodes()) {
                        Rectangle2D bounds = n.getBounds();
                        if (!isCtrl && !lasso.contains(bounds)) {
                            GraphPanel.this.selectionHandler.removeElementFromSelection(n);
                            continue;
                        }
                        if (!lasso.contains(bounds)) continue;
                        GraphPanel.this.selectionHandler.addSelectedElement(n);
                    }
                }
                GraphPanel.this.lastMousePoint = mousePoint;
                GraphPanel.this.repaint();
            }
        });
    }

    public SideToolPanel.Listener getToolListener() {
        if (this.toolListener == null) {
            this.toolListener = new SideToolPanel.Listener(){

                @Override
                public void toolSelectionChanged(Tool tool) {
                    GraphPanel.this.selectedTool = tool.getNodeOrEdge();
                }
            };
        }
        return this.toolListener;
    }

    public void editSelected() {
        Cloneable edited = null;
        if (this.selectionHandler.isNodeSelectedAtLeast()) {
            edited = this.selectionHandler.getLastSelectedNode();
        }
        if (this.selectionHandler.isEdgeSelectedAtLeast()) {
            edited = this.selectionHandler.getLastSelectedEdge();
        }
        if (edited == null) {
            return;
        }
        PropertySheet sheet = new PropertySheet(edited);
        sheet.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent event) {
                DiagramLinkNode ln;
                DiagramLink dl;
                if (event.getSource() instanceof DiagramLinkNode && (dl = (ln = (DiagramLinkNode)event.getSource()).getDiagramLink()) != null && dl.getOpenFlag().booleanValue()) {
                    GraphPanel.this.diagramPanel.fireMustOpenFile(dl.getURL());
                    dl.setOpenFlag(new Boolean(false));
                }
                GraphPanel.this.capturedEdit.addEdit(new AbstractUndoableEdit(){

                    @Override
                    public void undo() throws CannotUndoException {
                        PropertyUtils.setProperty(event.getSource(), event.getPropertyName(), event.getOldValue());
                        super.undo();
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        PropertyUtils.setProperty(event.getSource(), event.getPropertyName(), event.getNewValue());
                        super.redo();
                    }
                });
                GraphPanel.this.graph.layout((Graphics2D)GraphPanel.this.getGraphics(), GraphPanel.this.grid);
                GraphPanel.this.repaint();
            }
        });
        JOptionPane optionPane = new JOptionPane();
        optionPane.setOpaque(false);
        if (sheet.isEditable()) {
            optionPane.setMessage(sheet.getComponent());
            this.startCaptureEdit();
        }
        if (!sheet.isEditable()) {
            String message = this.resourceBundle.getString("dialog.properties.empty_bean_message");
            JLabel label = new JLabel(message);
            label.setFont(label.getFont().deriveFont(0));
            optionPane.setMessage(label);
        }
        DialogFactory.getInstance().showDialog(optionPane, this.resourceBundle.getString("dialog.properties.title"), true);
        if (sheet.isEditable()) {
            this.stopCaptureEdit();
        }
    }

    private void startCaptureEdit() {
        this.capturedEdit = new CompoundEdit();
        this.graphModListener = new GraphModificationListener(){

            @Override
            public void childAttached(Graph g, final int index, final Node p, final Node c) {
                AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                    @Override
                    public void undo() throws CannotUndoException {
                        p.removeChild(c);
                        super.undo();
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        p.addChild(index, c);
                    }
                };
                GraphPanel.this.capturedEdit.addEdit(edit);
            }

            @Override
            public void childDetached(Graph g, final int index, final Node p, final Node c) {
                AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                    @Override
                    public void undo() throws CannotUndoException {
                        p.addChild(index, c);
                        super.undo();
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        p.removeChild(c);
                    }
                };
                GraphPanel.this.capturedEdit.addEdit(edit);
            }

            @Override
            public void edgeAdded(final Graph g, final Edge e) {
                AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                    @Override
                    public void undo() throws CannotUndoException {
                        g.removeEdge(e);
                        super.undo();
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        g.connect(e, e.getStart(), e.getEnd());
                    }
                };
                GraphPanel.this.capturedEdit.addEdit(edit);
            }

            @Override
            public void edgeRemoved(final Graph g, final Edge e) {
                AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                    @Override
                    public void undo() throws CannotUndoException {
                        g.connect(e, e.getStart(), e.getEnd());
                        super.undo();
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        g.removeEdge(e);
                    }
                };
                GraphPanel.this.capturedEdit.addEdit(edit);
            }

            @Override
            public void nodeAdded(final Graph g, final Node n) {
                AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                    @Override
                    public void undo() throws CannotUndoException {
                        g.removeNode(n);
                        super.undo();
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        g.addNode(n, n.getLocation());
                    }
                };
                GraphPanel.this.capturedEdit.addEdit(edit);
            }

            @Override
            public void nodeRemoved(final Graph g, final Node n) {
                AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                    @Override
                    public void undo() throws CannotUndoException {
                        g.addNode(n, n.getLocation());
                        super.undo();
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        g.removeNode(n);
                    }
                };
                GraphPanel.this.capturedEdit.addEdit(edit);
            }

            @Override
            public void nodeMoved(Graph g, final Node n, final double dx, final double dy) {
                AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                    @Override
                    public void undo() throws CannotUndoException {
                        n.translate(-dx, -dy);
                        super.undo();
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        n.translate(dx, dy);
                    }
                };
                GraphPanel.this.capturedEdit.addEdit(edit);
            }

            @Override
            public void propertyChange(final PropertyChangeEvent event) {
                AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                    @Override
                    public void undo() throws CannotUndoException {
                        PropertyUtils.setProperty(event.getSource(), event.getPropertyName(), event.getOldValue());
                        super.undo();
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        PropertyUtils.setProperty(event.getSource(), event.getPropertyName(), event.getNewValue());
                    }
                };
                GraphPanel.this.capturedEdit.addEdit(edit);
            }
        };
        this.graph.addGraphModificationListener(this.graphModListener);
    }

    private void stopCaptureEdit() {
        if (this.capturedEdit == null) {
            return;
        }
        this.graph.removeGraphModificationListener(this.graphModListener);
        this.capturedEdit.end();
        this.undoManager.addEdit(this.capturedEdit);
        this.capturedEdit = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNodeAtPoint(Node newNode, Point2D location) {
        boolean isAdded = false;
        this.startCaptureEdit();
        try {
            if (this.graph.addNodeAtPoint(newNode, location)) {
                newNode.incrementRevision();
                this.graph.layout((Graphics2D)this.getGraphics(), this.grid);
            }
        }
        finally {
            this.stopCaptureEdit();
        }
        this.fireEventHappenedOnNode(GraphPanelEventType.NODE_ADDED, newNode);
        return isAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEdgeAtPoints(Edge newEdge, Point2D startPoint, Point2D endPoint) {
        boolean isAdded = false;
        if (startPoint.distance(endPoint) > 8.0) {
            this.startCaptureEdit();
            try {
                if (this.graph.addEdgeAtPoints(newEdge, startPoint, endPoint)) {
                    newEdge.incrementRevision();
                    this.graph.layout((Graphics2D)this.getGraphics(), this.grid);
                }
            }
            finally {
                this.stopCaptureEdit();
            }
            this.fireEventHappenedOnEdge(GraphPanelEventType.EDGE_ADDED, newEdge);
        }
        return isAdded;
    }

    public void updateNode(Node sourceNode, Node nodeToUpdate) {
        this.selectionHandler.addSelectedElement(nodeToUpdate);
        PropertyUtils.copyProperties(sourceNode, nodeToUpdate);
        this.fireEventHappenedOnNode(GraphPanelEventType.NODE_UDPATED, nodeToUpdate);
        this.selectionHandler.removeElementFromSelection(nodeToUpdate);
        this.graph.layout((Graphics2D)this.getGraphics(), this.grid);
    }

    public void updateEdge(Edge sourceEdge, Edge edgeToUpdate) {
        this.selectionHandler.addSelectedElement(edgeToUpdate);
        PropertyUtils.copyProperties(sourceEdge, edgeToUpdate);
        this.fireEventHappenedOnEdge(GraphPanelEventType.EDGE_UDPATED, edgeToUpdate);
        this.selectionHandler.removeElementFromSelection(edgeToUpdate);
        this.graph.layout((Graphics2D)this.getGraphics(), this.grid);
    }

    public void removeNode(Node aNode) {
        this.graph.removeNodesAndEdges(Arrays.asList(aNode), null);
    }

    public void removeEdge(Edge anEdge) {
        this.graph.removeNodesAndEdges(null, Arrays.asList(anEdge));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelected() {
        this.startCaptureEdit();
        try {
            this.graph.removeNodesAndEdges(this.selectionHandler.getSelectedNodes(), this.selectionHandler.getSelectedEdges());
            this.graph.layout((Graphics2D)this.getGraphics(), this.grid);
        }
        finally {
            this.stopCaptureEdit();
        }
        this.selectionHandler.clearSelection();
        this.repaint();
    }

    public void cut() {
        this.copy();
        this.removeSelected();
    }

    public void copy() {
        UMLEditor.getInstance().getClipboard().copyIn(this.graph, this.selectionHandler.getSelectedNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paste() {
        this.startCaptureEdit();
        try {
            Collection<Node> pastedNodes = UMLEditor.getInstance().getClipboard().pasteOut(this.graph, this.selectionHandler.getLastSelectedNode());
            if (pastedNodes != null) {
                this.selectionHandler.clearSelection();
                for (Node n : pastedNodes) {
                    this.selectionHandler.addSelectedElement(n);
                }
                this.graph.layout((Graphics2D)this.getGraphics(), this.grid);
            }
        }
        finally {
            this.stopCaptureEdit();
        }
        this.repaint();
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void paintComponent(Graphics g) {
        Color oldColor;
        super.paintComponent(g);
        if (this.grid == null) {
            this.grid = new Grid();
            this.grid.setGrid((int)this.gridSize, (int)this.gridSize);
            this.graph.layout((Graphics2D)this.getGraphics(), this.grid);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.zoom, this.zoom);
        Rectangle bounds = this.getBounds();
        Rectangle2D graphBounds = this.graph.getBounds(g2);
        if (!this.hideGrid) {
            this.grid.draw(g2, new Rectangle2D.Double(0.0, 0.0, Math.max(bounds.getMaxX() / this.zoom, graphBounds.getMaxX()), Math.max(bounds.getMaxY() / this.zoom, graphBounds.getMaxY())));
        }
        this.graph.draw(g2, this.grid);
        List<Node> nodes = this.selectionHandler.getSelectedNodes();
        for (Node n : nodes) {
            if (!this.graph.getNodes().contains(n)) continue;
            Rectangle2D grabberBounds = n.getBounds();
            GraphPanel.drawGrabber(g2, grabberBounds.getMinX(), grabberBounds.getMinY());
            GraphPanel.drawGrabber(g2, grabberBounds.getMinX(), grabberBounds.getMaxY());
            GraphPanel.drawGrabber(g2, grabberBounds.getMaxX(), grabberBounds.getMinY());
            GraphPanel.drawGrabber(g2, grabberBounds.getMaxX(), grabberBounds.getMaxY());
        }
        List<Edge> edges = this.selectionHandler.getSelectedEdges();
        for (Edge e : edges) {
            if (!this.graph.getEdges().contains(e)) continue;
            Line2D line = e.getConnectionPoints();
            GraphPanel.drawGrabber(g2, line.getX1(), line.getY1());
            GraphPanel.drawGrabber(g2, line.getX2(), line.getY2());
        }
        if (this.dragMode == 2) {
            oldColor = g2.getColor();
            g2.setColor(PURPLE);
            g2.draw(new Line2D.Double(this.mouseDownPoint, this.lastMousePoint));
            g2.setColor(oldColor);
        } else if (this.dragMode == 3) {
            oldColor = g2.getColor();
            g2.setColor(PURPLE);
            double x1 = this.mouseDownPoint.getX();
            double y1 = this.mouseDownPoint.getY();
            double x2 = this.lastMousePoint.getX();
            double y2 = this.lastMousePoint.getY();
            Rectangle2D.Double lasso = new Rectangle2D.Double(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1 - x2), Math.abs(y1 - y2));
            g2.draw(lasso);
            g2.setColor(oldColor);
        }
    }

    public static void drawGrabber(Graphics2D g2, double x, double y) {
        int SIZE = 5;
        Color oldColor = g2.getColor();
        g2.setColor(PURPLE);
        g2.fill(new Rectangle2D.Double(x - 2.0, y - 2.0, 5.0, 5.0));
        g2.setColor(oldColor);
    }

    @Override
    public Dimension getPreferredSize() {
        Rectangle2D bounds = this.graph.getBounds((Graphics2D)this.getGraphics());
        return new Dimension((int)(this.zoom * bounds.getMaxX()), (int)(this.zoom * bounds.getMaxY()));
    }

    public void changeZoom(int steps) {
        int i;
        double FACTOR = Math.sqrt(Math.sqrt(2.0));
        for (i = 1; i <= steps; ++i) {
            this.zoom *= FACTOR;
        }
        for (i = 1; i <= -steps; ++i) {
            this.zoom /= FACTOR;
        }
        this.revalidate();
        this.repaint();
    }

    public void changeGridSize(int steps) {
        int i;
        double FACTOR = Math.sqrt(Math.sqrt(2.0));
        for (i = 1; i <= steps; ++i) {
            this.gridSize *= FACTOR;
        }
        for (i = 1; i <= -steps; ++i) {
            this.gridSize /= FACTOR;
        }
        this.grid.setGrid((int)this.gridSize, (int)this.gridSize);
        this.graph.layout((Graphics2D)this.getGraphics(), this.grid);
        this.repaint();
    }

    public void setSelectedElement(Node node) {
        this.selectionHandler.setSelectedElement(node);
    }

    public void selectNext(int n) {
        ArrayList<Cloneable> selectables = new ArrayList<Cloneable>();
        selectables.addAll(this.graph.getNodes());
        selectables.addAll(this.graph.getEdges());
        if (selectables.size() == 0) {
            return;
        }
        Collections.sort(selectables, new Comparator<Object>(){

            @Override
            public int compare(Object obj1, Object obj2) {
                double y2;
                double x2;
                double y1;
                double x1;
                if (obj1 instanceof Node) {
                    Rectangle2D bounds = ((Node)obj1).getBounds();
                    x1 = bounds.getX();
                    y1 = bounds.getY();
                } else {
                    Point2D start = ((Edge)obj1).getConnectionPoints().getP1();
                    x1 = start.getX();
                    y1 = start.getY();
                }
                if (obj2 instanceof Node) {
                    Rectangle2D bounds = ((Node)obj2).getBounds();
                    x2 = bounds.getX();
                    y2 = bounds.getY();
                } else {
                    Point2D start = ((Edge)obj2).getConnectionPoints().getP1();
                    x2 = start.getX();
                    y2 = start.getY();
                }
                if (y1 < y2) {
                    return -1;
                }
                if (y1 > y2) {
                    return 1;
                }
                if (x1 < x2) {
                    return -1;
                }
                if (x1 > x2) {
                    return 1;
                }
                return 0;
            }
        });
        Cloneable lastSelected = null;
        if (this.selectionHandler.isNodeSelectedAtLeast()) {
            lastSelected = this.selectionHandler.getLastSelectedNode();
        }
        if (this.selectionHandler.isEdgeSelectedAtLeast()) {
            lastSelected = this.selectionHandler.getLastSelectedEdge();
        }
        for (int index = lastSelected == null ? 0 : selectables.indexOf(lastSelected) + n; index < 0; index += selectables.size()) {
        }
        Object toSelect = selectables.get(index %= selectables.size());
        if (toSelect instanceof Node) {
            this.selectionHandler.setSelectedElement((Node)toSelect);
        }
        if (toSelect instanceof Edge) {
            this.selectionHandler.setSelectedElement((Edge)toSelect);
        }
        this.repaint();
    }

    public void setHideGrid(boolean newValue) {
        this.hideGrid = newValue;
        this.repaint();
    }

    public boolean getHideGrid() {
        return this.hideGrid;
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
            this.graph.layout((Graphics2D)this.getGraphics(), this.grid);
            this.repaint();
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
            this.graph.layout((Graphics2D)this.getGraphics(), this.grid);
            this.repaint();
        }
    }

    public synchronized void addListener(GraphPanelListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    private void fireEventHappenedOnNode(GraphPanelEventType evtType, Node n) {
        Vector<GraphPanelListener> tl = this.cloneListeners();
        int size = tl.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            GraphPanelListener aListener = tl.elementAt(i);
            aListener.eventHappenedOnNode(evtType, n);
        }
    }

    private synchronized Vector<GraphPanelListener> cloneListeners() {
        return (Vector)this.listeners.clone();
    }

    private void fireEventHappenedOnEdge(GraphPanelEventType evtType, Edge e) {
        Vector<GraphPanelListener> tl = this.cloneListeners();
        int size = tl.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            GraphPanelListener aListener = tl.elementAt(i);
            aListener.eventHappenedOnEdge(evtType, e);
        }
    }

    public void notifySaved() {
        this.undoManager.discardAllEdits();
    }

    public boolean isDirty() {
        return this.undoManager.canUndo();
    }
}

