/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import com.horstmann.violet.framework.diagram.ChoiceList;
import com.horstmann.violet.framework.diagram.ChoiceListEditor;
import com.horstmann.violet.framework.diagram.DiagramLink;
import com.horstmann.violet.framework.diagram.DiagramLinkEditor;
import com.horstmann.violet.framework.gui.ColorEditor;
import com.horstmann.violet.framework.gui.FormLayout;
import com.horstmann.violet.framework.util.SerializableEnumeration;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PropertySheet {
    private static Set<Class<?>> knownImmutables = new HashSet();
    private ArrayList<PropertyChangeListener> listeners = new ArrayList();
    private boolean isEditable = false;
    private static Map<Class<?>, Class<? extends PropertyEditor>> editors;
    private JPanel panel = new JPanel();

    public PropertySheet(Object bean) {
        try {
            BeanInfo info = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] descriptors = (PropertyDescriptor[])info.getPropertyDescriptors().clone();
            Arrays.sort(descriptors, new Comparator<PropertyDescriptor>(){

                @Override
                public int compare(PropertyDescriptor d1, PropertyDescriptor d2) {
                    Integer p1 = (Integer)d1.getValue("priority");
                    Integer p2 = (Integer)d2.getValue("priority");
                    if (p1 == null && p2 == null) {
                        return 0;
                    }
                    if (p1 == null) {
                        return 1;
                    }
                    if (p2 == null) {
                        return -1;
                    }
                    return p1 - p2;
                }
            });
            this.panel.setLayout(new FormLayout());
            ResourceBundle rs = ResourceBundle.getBundle("properties.NodeAndEdgeStrings", Locale.getDefault());
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyEditor editor = this.getEditor(bean, descriptors[i]);
                if (editor == null) continue;
                String title = descriptors[i].getName();
                try {
                    String translatedTitle = rs.getString(title.toLowerCase());
                    if (translatedTitle != null) {
                        title = translatedTitle;
                    }
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
                title = title.substring(0, Math.min(1, title.length())).toUpperCase() + title.substring(Math.min(1, title.length()), title.length());
                JLabel label = new JLabel(title);
                label.setFont(label.getFont().deriveFont(0));
                this.panel.add(label);
                this.panel.add(this.getEditorComponent(editor));
                this.isEditable = true;
            }
        }
        catch (IntrospectionException exception) {
            exception.printStackTrace();
        }
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public PropertyEditor getEditor(final Object bean, final PropertyDescriptor descriptor) {
        try {
            PropertyEditor editor;
            Method getter = descriptor.getReadMethod();
            if (getter == null) {
                return null;
            }
            final Method setter = descriptor.getWriteMethod();
            if (setter == null) {
                return null;
            }
            Class<?> type = descriptor.getPropertyType();
            Class<Object> editorClass = descriptor.getPropertyEditorClass();
            if (editorClass == null && editors.containsKey(type)) {
                editorClass = editors.get(type);
            }
            if ((editor = editorClass != null ? (PropertyEditor)editorClass.newInstance() : PropertyEditorManager.findEditor(type)) == null) {
                return null;
            }
            Object value = getter.invoke(bean, new Object[0]);
            editor.setValue(value);
            if (!PropertySheet.isKnownImmutable(type)) {
                try {
                    value = value.getClass().getMethod("clone", new Class[0]).invoke(value, new Object[0]);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            final Object oldValue = value;
            editor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    try {
                        Object newValue = editor.getValue();
                        setter.invoke(bean, newValue);
                        PropertySheet.this.firePropertyStateChanged(new PropertyChangeEvent(bean, descriptor.getName(), oldValue, newValue));
                    }
                    catch (IllegalAccessException exception) {
                        exception.printStackTrace();
                    }
                    catch (InvocationTargetException exception) {
                        exception.printStackTrace();
                    }
                }
            });
            return editor;
        }
        catch (InstantiationException exception) {
            exception.printStackTrace();
            return null;
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
            return null;
        }
        catch (InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static boolean isKnownImmutable(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (knownImmutables.contains(type)) {
            return true;
        }
        return SerializableEnumeration.class.isAssignableFrom(type);
    }

    private Component getEditorComponent(final PropertyEditor editor) {
        String[] tags = editor.getTags();
        String text = editor.getAsText();
        if (editor.supportsCustomEditor()) {
            return editor.getCustomEditor();
        }
        if (tags != null) {
            final JComboBox<String> comboBox = new JComboBox<String>(tags);
            comboBox.setSelectedItem(text);
            comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        editor.setAsText((String)comboBox.getSelectedItem());
                    }
                }
            });
            return comboBox;
        }
        final JTextField textField = new JTextField(text, 10);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    editor.setAsText(textField.getText());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    editor.setAsText(textField.getText());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        return textField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        ArrayList<PropertyChangeListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        ArrayList<PropertyChangeListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyStateChanged(PropertyChangeEvent event) {
        ArrayList<PropertyChangeListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (PropertyChangeListener listener : this.listeners) {
                listener.propertyChange(event);
            }
        }
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    static {
        knownImmutables.add(String.class);
        knownImmutables.add(Integer.class);
        knownImmutables.add(Boolean.class);
        knownImmutables.add(Double.class);
        editors = new HashMap();
        editors.put(String.class, StringEditor.class);
        editors.put(Color.class, ColorEditor.class);
        editors.put(DiagramLink.class, DiagramLinkEditor.class);
        editors.put(ChoiceList.class, ChoiceListEditor.class);
    }

    public static class StringEditor
    extends PropertyEditorSupport {
        @Override
        public String getAsText() {
            return (String)this.getValue();
        }

        @Override
        public void setAsText(String s) {
            this.setValue(s);
        }
    }
}

