/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.menu;

import com.horstmann.violet.framework.action.EditAction;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.EditorFrame;
import com.horstmann.violet.framework.resources.ResourceFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;

public class EditMenu
extends JMenu {
    private ResourceFactory factory;
    private JTabbedPane tabbedPane;
    private EditAction editAction;

    public EditMenu(EditorFrame editorFrame, ResourceFactory factory) {
        this.tabbedPane = editorFrame.getTabbedPane();
        this.factory = factory;
        this.editAction = new EditAction();
        this.createMenu();
    }

    private void createMenu() {
        this.factory.configureMenu(this, "edit");
        JMenuItem undo = this.factory.createMenuItem("edit.undo");
        undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMenu.this.performUndo();
            }
        });
        this.add(undo);
        JMenuItem redo = this.factory.createMenuItem("edit.redo");
        redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMenu.this.performRedo();
            }
        });
        this.add(redo);
        JMenuItem properties = this.factory.createMenuItem("edit.properties");
        properties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMenu.this.performEditProperties();
            }
        });
        this.add(properties);
        JMenuItem cut = this.factory.createMenuItem("edit.cut");
        cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMenu.this.performCut();
            }
        });
        this.add(cut);
        JMenuItem copy = this.factory.createMenuItem("edit.copy");
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMenu.this.performCopy();
            }
        });
        this.add(copy);
        JMenuItem paste = this.factory.createMenuItem("edit.paste");
        paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMenu.this.performPaste();
            }
        });
        this.add(paste);
        JMenuItem delete = this.factory.createMenuItem("edit.delete");
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMenu.this.performDelete();
            }
        });
        this.add(delete);
        JMenuItem selectNext = this.factory.createMenuItem("edit.select_next");
        selectNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMenu.this.performSelectNext();
            }
        });
        this.add(selectNext);
        JMenuItem selectPrevious = this.factory.createMenuItem("edit.select_previous");
        selectPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMenu.this.performSelectPrevious();
            }
        });
        this.add(selectPrevious);
    }

    private void performUndo() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.editAction.undo(diagramPanel);
    }

    private void performRedo() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.editAction.redo(diagramPanel);
    }

    private void performEditProperties() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.editAction.edit(diagramPanel);
    }

    private void performCut() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.editAction.cut(diagramPanel);
    }

    private void performCopy() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.editAction.copy(diagramPanel);
    }

    private void performPaste() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.editAction.paste(diagramPanel);
    }

    private void performDelete() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.editAction.delete(diagramPanel);
    }

    private void performSelectNext() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.editAction.selectNext(diagramPanel);
    }

    private void performSelectPrevious() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.editAction.selectPrevious(diagramPanel);
    }
}

