/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.sidebar;

import com.horstmann.violet.framework.action.EditAction;
import com.horstmann.violet.framework.action.ViewAction;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.resources.ResourceFactory;
import com.horstmann.violet.framework.swingextension.IconButtonUI;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SideShortcutMandatoryPanel
extends JPanel {
    private DiagramPanel diagramPanel;
    private ViewAction viewAction;
    private EditAction editAction;

    public SideShortcutMandatoryPanel(final DiagramPanel diagramPanel, ResourceBundle sideBarResourceBundle) {
        this.diagramPanel = diagramPanel;
        this.viewAction = new ViewAction();
        this.editAction = new EditAction();
        this.setBackground(ThemeManager.getInstance().getTheme().getSIDEBAR_ELEMENT_BACKGROUND_COLOR());
        ResourceFactory factory = new ResourceFactory(sideBarResourceBundle);
        JButton bZoomIn = factory.createButton("zoomin");
        bZoomIn.setUI(new IconButtonUI());
        bZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutMandatoryPanel.this.performZoomIn();
            }
        });
        JButton bZoomOut = factory.createButton("zoomout");
        bZoomOut.setUI(new IconButtonUI());
        bZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutMandatoryPanel.this.performZoomOut();
            }
        });
        JButton bUndo = factory.createButton("undo");
        bUndo.setUI(new IconButtonUI());
        bUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutMandatoryPanel.this.performUndo();
            }
        });
        JButton bRedo = factory.createButton("redo");
        bRedo.setUI(new IconButtonUI());
        bRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutMandatoryPanel.this.performRedo();
            }
        });
        JButton bDelete = factory.createButton("delete");
        bDelete.setUI(new IconButtonUI());
        bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutMandatoryPanel.this.performDelete();
            }
        });
        JButton bCut = factory.createButton("cut");
        bCut.setUI(new IconButtonUI());
        bCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutMandatoryPanel.this.editAction.cut(diagramPanel);
            }
        });
        JButton bCopy = factory.createButton("copy");
        bCopy.setUI(new IconButtonUI());
        bCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutMandatoryPanel.this.editAction.copy(diagramPanel);
            }
        });
        JButton bPaste = factory.createButton("paste");
        bPaste.setUI(new IconButtonUI());
        bPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutMandatoryPanel.this.editAction.paste(diagramPanel);
            }
        });
        JPanel panel = new JPanel();
        GridLayout layout = new GridLayout(0, 5);
        layout.setHgap(15);
        panel.setLayout(layout);
        panel.setOpaque(false);
        panel.setBorder(new EmptyBorder(0, 5, 0, 0));
        panel.add(bUndo);
        panel.add(bZoomIn);
        panel.add(bZoomOut);
        panel.add(bDelete);
        panel.add(bRedo);
        panel.add(bCut);
        panel.add(bCopy);
        panel.add(bPaste);
        this.setLayout(new FlowLayout(0));
        this.add(panel);
    }

    private void performZoomIn() {
        this.viewAction.zoomIn(this.diagramPanel);
    }

    private void performZoomOut() {
        this.viewAction.zoomOut(this.diagramPanel);
    }

    private void performUndo() {
        this.editAction.undo(this.diagramPanel);
    }

    private void performRedo() {
        this.editAction.redo(this.diagramPanel);
    }

    private void performDelete() {
        this.editAction.delete(this.diagramPanel);
    }
}

