/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.network;

import com.horstmann.violet.framework.network.receiver.IReceiver;
import com.horstmann.violet.framework.network.sender.ISender;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class NetworkSession {
    private String senderID;
    private Map<String, URL> recipients;
    private IReceiver receiver;
    private ISender sender;

    public NetworkSession(String senderID, IReceiver receiver, ISender sender) {
        this.senderID = senderID;
        this.recipients = new HashMap<String, URL>();
        this.receiver = receiver;
        this.sender = sender;
    }

    public void addRecipient(String recipientID, URL recipientURL) {
        URL localURL = this.getReceiver().getURL();
        if (!this.recipients.containsKey(recipientID) && !recipientURL.equals(localURL)) {
            this.recipients.put(recipientID, recipientURL);
        }
    }

    public void removeRecipient(String recipientID) {
        this.recipients.remove(recipientID);
    }

    public String getSenderID() {
        return this.senderID;
    }

    public URL[] getRecipients() {
        Collection<URL> r = this.recipients.values();
        URL[] result = r.toArray(new URL[r.size()]);
        return result;
    }

    public URL getRecipient(String userID) {
        URL recipientURL = this.recipients.get(userID);
        return recipientURL;
    }

    public IReceiver getReceiver() {
        return this.receiver;
    }

    public ISender getSender() {
        return this.sender;
    }

    public String toString() {
        URL localURL = this.receiver.getURL();
        return localURL.toString();
    }
}

