/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.object;

import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.diagram.RectangularNode;
import com.horstmann.violet.product.diagram.common.PointNode;
import com.horstmann.violet.product.diagram.object.FieldNode;
import com.horstmann.violet.product.diagram.object.ObjectRelationshipEdge;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class ObjectNode
extends RectangularNode {
    private transient double topHeight;
    private MultiLineString name = new MultiLineString();
    private static int DEFAULT_WIDTH = 80;
    private static int DEFAULT_HEIGHT = 60;
    private static int XGAP = 5;
    private static int YGAP = 5;

    public ObjectNode() {
        this.name.setUnderlined(true);
        this.name.setSize(3);
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        Rectangle2D top = this.getTopRectangle();
        g2.draw(top);
        g2.draw(this.getBounds());
        this.name.draw(g2, top);
    }

    @Override
    public void translate(double dx, double dy) {
        super.translate(dx, dy);
        for (Node childNode : this.getChildren()) {
            childNode.translate(dx, dy);
        }
    }

    public Rectangle2D getTopRectangle() {
        return new Rectangle2D.Double(this.getBounds().getX(), this.getBounds().getY(), this.getBounds().getWidth(), this.topHeight);
    }

    @Override
    public boolean checkAddEdge(Edge e, Point2D p1, Point2D p2) {
        return e instanceof ObjectRelationshipEdge && e.getEnd() != null;
    }

    @Override
    public Point2D getConnectionPoint(Direction d) {
        if (d.getX() > 0.0) {
            return new Point2D.Double(this.getBounds().getMaxX(), this.getBounds().getMinY() + this.topHeight / 2.0);
        }
        return new Point2D.Double(this.getBounds().getX(), this.getBounds().getMinY() + this.topHeight / 2.0);
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        Rectangle2D b = this.name.getBounds(g2);
        b.add(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT - YGAP));
        double leftWidth = 0.0;
        double rightWidth = 0.0;
        List<Node> fields = this.getChildren();
        double height = fields.size() == 0 ? 0.0 : (double)YGAP;
        for (Node n : fields) {
            FieldNode f = (FieldNode)n;
            f.layout(g2, grid);
            Rectangle2D b2 = f.getBounds();
            height += b2.getHeight() + (double)YGAP;
            double axis = f.getAxisX();
            leftWidth = Math.max(leftWidth, axis);
            rightWidth = Math.max(rightWidth, b2.getWidth() - axis);
        }
        double width = 2.0 * Math.max(leftWidth, rightWidth) + (double)(2 * XGAP);
        width = Math.max(width, b.getWidth());
        width = Math.max(width, (double)DEFAULT_WIDTH);
        this.snapBounds(grid, width, b.getHeight() + height);
        this.topHeight = this.getBounds().getHeight() - height;
        double ytop = this.getBounds().getY() + this.topHeight + (double)YGAP;
        double xmid = this.getBounds().getCenterX();
        for (Node n : fields) {
            FieldNode f = (FieldNode)n;
            f.translate(xmid - f.getAxisX() - f.getLocation().getX(), ytop - f.getLocation().getY());
            ytop += f.getBounds().getHeight() + (double)YGAP;
        }
    }

    public void setName(MultiLineString n) {
        this.name = n;
    }

    public MultiLineString getName() {
        return this.name;
    }

    @Override
    public boolean checkAddNode(Node n, Point2D p) {
        int i;
        List<Node> fields = this.getChildren();
        if (n instanceof PointNode) {
            return true;
        }
        if (!(n instanceof FieldNode)) {
            return false;
        }
        if (fields.contains(n)) {
            return true;
        }
        for (i = 0; i < fields.size() && fields.get(i).getLocation().getY() < p.getY(); ++i) {
        }
        this.addChild(i, n);
        return true;
    }

    @Override
    public void checkRemoveNode(Node n) {
        if (n == this) {
            ArrayList<Node> fields = new ArrayList<Node>(this.getChildren());
            for (int i = fields.size() - 1; i >= 0; --i) {
                Node field = (Node)fields.get(i);
                this.removeChild(field);
            }
            this.getGraph().removeNodesAndEdges(fields, null);
        }
    }

    @Override
    public ObjectNode clone() {
        ObjectNode cloned = (ObjectNode)super.clone();
        cloned.name = this.name.clone();
        return cloned;
    }
}

