/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.sequence;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.product.diagram.common.DiagramLinkNode;
import com.horstmann.violet.product.diagram.common.NoteEdge;
import com.horstmann.violet.product.diagram.common.NoteNode;
import com.horstmann.violet.product.diagram.sequence.ActivationBarNode;
import com.horstmann.violet.product.diagram.sequence.CallEdge;
import com.horstmann.violet.product.diagram.sequence.LifelineNode;
import com.horstmann.violet.product.diagram.sequence.ReturnEdge;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class SequenceDiagramGraph
extends Graph {
    private static final Node[] NODE_PROTOTYPES = new Node[4];
    private static final Edge[] EDGE_PROTOTYPES = new Edge[3];

    @Override
    public boolean addNodeAtPoint(Node n, Point2D p) {
        if (n instanceof ActivationBarNode) {
            Collection<Node> nodes = this.getNodes();
            boolean inside = false;
            Iterator<Node> iter = nodes.iterator();
            while (!inside && iter.hasNext()) {
                Node n2 = iter.next();
                if (!(n2 instanceof LifelineNode) || !n2.contains(p)) continue;
                inside = true;
                ((ActivationBarNode)n).setImplicitParameter((LifelineNode)n2);
            }
            if (!inside) {
                return false;
            }
        }
        return super.addNodeAtPoint(n, p);
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        ArrayList<ActivationBarNode> topLevelCalls = new ArrayList<ActivationBarNode>();
        ArrayList<LifelineNode> objects = new ArrayList<LifelineNode>();
        ArrayList<Node> otherNodes = new ArrayList<Node>();
        for (Node n : this.getNodes()) {
            if (n instanceof ActivationBarNode && n.getParent() == null) {
                topLevelCalls.add((ActivationBarNode)n);
                continue;
            }
            if (n instanceof LifelineNode) {
                objects.add((LifelineNode)n);
                continue;
            }
            if (n.getParent() != null) continue;
            otherNodes.add(n);
        }
        for (Edge e : this.getEdges()) {
            Node end;
            if (!(e instanceof CallEdge) || !((end = e.getEnd()) instanceof ActivationBarNode)) continue;
            ((ActivationBarNode)end).setSignaled(((CallEdge)e).isSignal());
        }
        double top = 0.0;
        for (LifelineNode lifelineNode : objects) {
            if (lifelineNode.getParent() != null) continue;
            lifelineNode.setZ(0);
            lifelineNode.translate(0.0, -lifelineNode.getLocation().getY());
            lifelineNode.layout(g2, grid);
            top = Math.max(top, lifelineNode.getTopRectangle().getMaxY());
        }
        Collections.sort(topLevelCalls, new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                double d = n1.getLocation().getY() - n2.getLocation().getY();
                if (d < 0.0) {
                    return -1;
                }
                if (d > 0.0) {
                    return 1;
                }
                d = n1.getLocation().getX() - n2.getLocation().getX();
                if (d < 0.0) {
                    return -1;
                }
                if (d > 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        for (ActivationBarNode activationBarNode : topLevelCalls) {
            activationBarNode.translate(0.0, (top += (double)ActivationBarNode.CALL_YGAP) - activationBarNode.getLocation().getY());
            activationBarNode.setZ(1);
            activationBarNode.layout(g2, grid);
            top += activationBarNode.getBounds().getHeight();
        }
        top += (double)ActivationBarNode.CALL_YGAP;
        for (LifelineNode lifelineNode : objects) {
            Rectangle2D b = lifelineNode.getBounds();
            lifelineNode.setBounds(new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), top - b.getY()));
        }
        for (Node node : otherNodes) {
            node.layout(g2, grid);
        }
    }

    @Override
    public Node[] getNodePrototypes() {
        return NODE_PROTOTYPES;
    }

    @Override
    public Edge[] getEdgePrototypes() {
        return EDGE_PROTOTYPES;
    }

    static {
        SequenceDiagramGraph.NODE_PROTOTYPES[0] = new LifelineNode();
        SequenceDiagramGraph.NODE_PROTOTYPES[1] = new ActivationBarNode();
        SequenceDiagramGraph.NODE_PROTOTYPES[2] = new NoteNode();
        SequenceDiagramGraph.NODE_PROTOTYPES[3] = new DiagramLinkNode();
        SequenceDiagramGraph.EDGE_PROTOTYPES[0] = new CallEdge();
        SequenceDiagramGraph.EDGE_PROTOTYPES[1] = new ReturnEdge();
        SequenceDiagramGraph.EDGE_PROTOTYPES[2] = new NoteEdge();
    }
}

