/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.usecase;

import com.horstmann.violet.framework.diagram.EllipticalNode;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class UseCaseNode
extends EllipticalNode {
    private MultiLineString name = new MultiLineString();
    private static int DEFAULT_WIDTH = 110;
    private static int DEFAULT_HEIGHT = 40;

    public UseCaseNode() {
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        g2.draw(this.getShape());
        this.name.draw(g2, this.getBounds());
    }

    public void setName(MultiLineString newValue) {
        this.name = newValue;
    }

    public MultiLineString getName() {
        return this.name;
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        double aspectRatio = DEFAULT_WIDTH / DEFAULT_HEIGHT;
        Rectangle2D b = this.name.getBounds(g2);
        double bw = b.getWidth();
        double bh = b.getHeight();
        double minWidth = Math.sqrt(bw * bw + aspectRatio * aspectRatio * bh * bh);
        double minHeight = minWidth / aspectRatio;
        this.snapBounds(grid, Math.max(minWidth, (double)DEFAULT_WIDTH), Math.max(minHeight, (double)DEFAULT_HEIGHT));
    }

    @Override
    public UseCaseNode clone() {
        UseCaseNode cloned = (UseCaseNode)super.clone();
        cloned.name = this.name.clone();
        return cloned;
    }
}

