/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.db2;

public class PageSize {
    public static final PageSize PAGESIZE_4096 = new PageSize(4096L);
    public static final PageSize PAGESIZE_8192 = new PageSize(8192L);
    public static final PageSize PAGESIZE_16384 = new PageSize(16384L);
    public static final PageSize PAGESIZE_32768 = new PageSize(32768L);
    private static final PageSize[] instances = new PageSize[]{PAGESIZE_4096, PAGESIZE_8192, PAGESIZE_16384, PAGESIZE_32768};
    private long size;

    private PageSize(long pSize) {
        this.size = pSize;
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        return "PAGESIZE_" + this.size;
    }

    public boolean equals(Object pOther) {
        return pOther != null && pOther instanceof PageSize && this.size == ((PageSize)pOther).size;
    }

    public static PageSize[] getInstances() {
        return instances;
    }

    public static PageSize valueOf(String pSize) {
        long l;
        try {
            l = Long.parseLong(pSize);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("PageSize is no long value: " + pSize);
        }
        return PageSize.valueOf(l);
    }

    public static PageSize valueOf(long pSize) {
        for (int i = 0; i < instances.length; ++i) {
            if (PageSize.instances[i].size != pSize) continue;
            return instances[i];
        }
        throw new IllegalArgumentException("Invalid page size: " + pSize);
    }

    public int hashCode() {
        return (int)this.size / 4096;
    }
}

