/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.util.SerializableEnumeration;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ArrowHead
extends SerializableEnumeration {
    public static final ArrowHead NONE = new ArrowHead();
    public static final ArrowHead TRIANGLE = new ArrowHead();
    public static final ArrowHead BLACK_TRIANGLE = new ArrowHead();
    public static final ArrowHead V = new ArrowHead();
    public static final ArrowHead HALF_V = new ArrowHead();
    public static final ArrowHead DIAMOND = new ArrowHead();
    public static final ArrowHead BLACK_DIAMOND = new ArrowHead();
    private static final long serialVersionUID = -3824887997763775890L;

    public void draw(Graphics2D g2, Point2D p, Point2D q) {
        GeneralPath path = this.getPath(p, q);
        Color oldColor = g2.getColor();
        if (this == BLACK_DIAMOND || this == BLACK_TRIANGLE) {
            g2.setColor(Color.BLACK);
        } else {
            g2.setColor(Color.WHITE);
        }
        g2.fill(path);
        g2.setColor(oldColor);
        g2.draw(path);
    }

    public GeneralPath getPath(Point2D p, Point2D q) {
        GeneralPath path = new GeneralPath();
        if (this == NONE) {
            return path;
        }
        double ARROW_ANGLE = 0.5235987755982988;
        double ARROW_LENGTH = 10.0;
        double dx = q.getX() - p.getX();
        double dy = q.getY() - p.getY();
        double angle = Math.atan2(dy, dx);
        double x1 = q.getX() - 10.0 * Math.cos(angle + 0.5235987755982988);
        double y1 = q.getY() - 10.0 * Math.sin(angle + 0.5235987755982988);
        double x2 = q.getX() - 10.0 * Math.cos(angle - 0.5235987755982988);
        double y2 = q.getY() - 10.0 * Math.sin(angle - 0.5235987755982988);
        if (this == V) {
            path.moveTo((float)x1, (float)y1);
            path.lineTo((float)q.getX(), (float)q.getY());
            path.lineTo((float)x2, (float)y2);
            path.lineTo((float)q.getX(), (float)q.getY());
            path.lineTo((float)x1, (float)y1);
            path.closePath();
        } else if (this == TRIANGLE || this == BLACK_TRIANGLE) {
            path.moveTo((float)q.getX(), (float)q.getY());
            path.lineTo((float)x1, (float)y1);
            path.lineTo((float)x2, (float)y2);
            path.closePath();
        } else if (this == DIAMOND || this == BLACK_DIAMOND) {
            path.moveTo((float)q.getX(), (float)q.getY());
            path.lineTo((float)x1, (float)y1);
            double x3 = x2 - 10.0 * Math.cos(angle + 0.5235987755982988);
            double y3 = y2 - 10.0 * Math.sin(angle + 0.5235987755982988);
            path.lineTo((float)x3, (float)y3);
            path.lineTo((float)x2, (float)y2);
            path.closePath();
        }
        return path;
    }
}

