/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.file;

import com.horstmann.violet.framework.file.ExtensionFilter;
import com.horstmann.violet.framework.file.FileChooserService;
import com.horstmann.violet.framework.file.FileOpenerHandler;
import com.horstmann.violet.framework.file.FileSaverHandler;
import com.horstmann.violet.framework.file.FileService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class JNLPFileChooserService
implements FileChooserService {
    private FileOpenService openService;
    private FileSaveService saveService;

    public JNLPFileChooserService() {
        try {
            this.openService = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
            this.saveService = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
        }
        catch (UnavailableServiceException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isWebStart() {
        return true;
    }

    @Override
    public FileOpenerHandler open(String defaultDirectory, String defaultFile, ExtensionFilter[] filters) throws IOException {
        if (defaultDirectory == null) {
            defaultDirectory = ".";
        }
        ArrayList<String> fileExtensions = new ArrayList<String>();
        for (int i = 0; i < filters.length; ++i) {
            ExtensionFilter aFilter = filters[i];
            String[] filterExtensions = aFilter.getExtensions();
            for (int j = 0; j < filterExtensions.length; ++j) {
                fileExtensions.add(filterExtensions[j]);
            }
        }
        String[] fileExtensionsStrings = fileExtensions.toArray(new String[fileExtensions.size()]);
        final FileContents contents = this.openService.openFileDialog(defaultDirectory, fileExtensionsStrings);
        return new FileOpenerHandler(){

            @Override
            public InputStream getInputStream() throws IOException {
                return contents.getInputStream();
            }

            @Override
            public String getName() throws IOException {
                return contents.getName();
            }

            @Override
            public void initialize(File selectedFile) throws FileNotFoundException {
            }
        };
    }

    @Override
    public FileSaverHandler save(final String defaultDirectory, final String defaultFile, final ExtensionFilter filter, final String removeExtension, final String addExtension) throws IOException {
        return new FileSaverHandler(){
            private ByteArrayOutputStream bout = new ByteArrayOutputStream();
            private FileContents contents;
            private OutputStream out = new FilterOutputStream(this.bout){

                @Override
                public void close() {
                    try {
                        super.close();
                        this.showDialog();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            };

            @Override
            public String getName() throws IOException {
                if (this.contents == null) {
                    return null;
                }
                return this.contents.getName();
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return this.out;
            }

            public void showDialog() throws IOException {
                this.contents = JNLPFileChooserService.this.saveService.saveFileDialog(defaultDirectory, filter.getExtensions(), (InputStream)new ByteArrayInputStream(this.bout.toByteArray()), FileService.editExtension(defaultFile, removeExtension, addExtension));
            }

            @Override
            public void initialize(File selectedFile) throws FileNotFoundException {
            }
        };
    }
}

