/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

class FormLayout
implements LayoutManager {
    private int left;
    private int right;
    private int height;
    private static final int GAP = 6;

    FormLayout() {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Component[] components = parent.getComponents();
        this.left = 0;
        this.right = 0;
        this.height = 0;
        for (int i = 0; i < components.length; i += 2) {
            Component cleft = components[i];
            Component cright = components[i + 1];
            Dimension dleft = cleft.getPreferredSize();
            Dimension dright = cright.getPreferredSize();
            this.left = Math.max(this.left, dleft.width);
            this.right = Math.max(this.right, dright.width);
            this.height += Math.max(dleft.height, dright.height);
        }
        return new Dimension(this.left + 6 + this.right, this.height);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.preferredLayoutSize(parent);
        Component[] components = parent.getComponents();
        Insets insets = parent.getInsets();
        int xcenter = insets.left + this.left;
        int y = insets.top;
        for (int i = 0; i < components.length; i += 2) {
            Component cleft = components[i];
            Component cright = components[i + 1];
            Dimension dleft = cleft.getPreferredSize();
            Dimension dright = cright.getPreferredSize();
            int height = Math.max(dleft.height, dright.height);
            cleft.setBounds(xcenter - dleft.width, y + (height - dleft.height) / 2, dleft.width, dleft.height);
            cright.setBounds(xcenter + 6, y + (height - dright.height) / 2, dright.width, dright.height);
            y += height;
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

