/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.sidebar;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.gui.GraphPanel;
import com.horstmann.violet.product.diagram.common.PointNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;

public class Tool {
    private Object nodeOrEdge;
    private Icon icon;
    private String label;
    private static final int ICON_SIZE = 20;
    private static final int OFFSET = 4;

    public Tool(final Edge e, String label) {
        this.nodeOrEdge = e;
        this.label = label;
        this.icon = new Icon(){

            @Override
            public int getIconHeight() {
                return 20;
            }

            @Override
            public int getIconWidth() {
                return 20;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                PointNode p = new PointNode();
                p.translate(4.0, 4.0);
                PointNode q = new PointNode();
                q.translate(16.0, 16.0);
                e.connect(p, q);
                Rectangle2D.Double bounds = new Rectangle2D.Double();
                bounds.add(p.getBounds());
                bounds.add(q.getBounds());
                bounds.add(e.getBounds(g2));
                double width = ((RectangularShape)bounds).getWidth();
                double height = ((RectangularShape)bounds).getHeight();
                double scaleX = 16.0 / width;
                double scaleY = 16.0 / height;
                double scale = Math.min(scaleX, scaleY);
                AffineTransform oldTransform = g2.getTransform();
                g2.translate(x, y);
                g2.scale(scale, scale);
                g2.translate(Math.max((height - width) / 2.0, 0.0), Math.max((width - height) / 2.0, 0.0));
                g2.setColor(Color.black);
                e.draw(g2);
                g2.setTransform(oldTransform);
            }
        };
    }

    public Tool(final Node n, String label) {
        this.nodeOrEdge = n;
        this.label = label;
        this.icon = new Icon(){

            @Override
            public int getIconHeight() {
                return 20;
            }

            @Override
            public int getIconWidth() {
                return 20;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                double width = n.getBounds().getWidth();
                double height = n.getBounds().getHeight();
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                double scaleX = 16.0 / width;
                double scaleY = 16.0 / height;
                double scale = Math.min(scaleX, scaleY);
                AffineTransform oldTransform = g2.getTransform();
                g2.translate(x + 2, y + 2);
                g2.scale(scale, scale);
                g2.translate(Math.max((height - width) / 2.0, 0.0), Math.max((width - height) / 2.0, 0.0));
                g2.setColor(Color.black);
                n.draw(g2);
                g2.setTransform(oldTransform);
            }
        };
    }

    public Tool() {
        this.icon = new Icon(){

            @Override
            public int getIconHeight() {
                return 20;
            }

            @Override
            public int getIconWidth() {
                return 20;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                GraphPanel.drawGrabber(g2, x + 4, y + 4);
                GraphPanel.drawGrabber(g2, x + 4, y + 20 - 4);
                GraphPanel.drawGrabber(g2, x + 20 - 4, y + 4);
                GraphPanel.drawGrabber(g2, x + 20 - 4, y + 20 - 4);
            }
        };
        ResourceBundle rs = ResourceBundle.getBundle("properties.OtherStrings", Locale.getDefault());
        this.label = rs.getString("grabber.tooltip");
        this.nodeOrEdge = null;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getLabel() {
        return this.label;
    }

    public Object getNodeOrEdge() {
        return this.nodeOrEdge;
    }
}

