/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.network.sender;

import com.horstmann.violet.framework.diagram.GraphService;
import com.horstmann.violet.framework.network.NetworkMessage;
import com.horstmann.violet.framework.network.NetworkMessageSubjectType;
import com.horstmann.violet.framework.network.sender.ISender;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class HTTPSender
implements ISender {
    private Map<URL, Long> badRecipientURL = new HashMap<URL, Long>();
    private static final int MAX_NOT_RESPONDING_DELAY = 1;

    @Override
    public void sendMessage(NetworkMessage msg) {
        String encodedMessage = null;
        try {
            String message = this.getString(msg);
            encodedMessage = URLEncoder.encode(message, "UTF-8");
            System.out.println(message);
        }
        catch (UnsupportedEncodingException e2) {
            // empty catch block
        }
        if (encodedMessage == null) {
            return;
        }
        String postData = "message=" + encodedMessage;
        URL[] urls = msg.getTo();
        for (int i = 0; i < urls.length; ++i) {
            Postman internalPostman = new Postman(urls[i], postData, this, msg);
            internalPostman.start();
        }
    }

    synchronized void registerBadRecipient(URL recipientURL, NetworkMessage concernedMessage) {
        Long startTime;
        if (!this.badRecipientURL.containsKey(recipientURL)) {
            this.badRecipientURL.put(recipientURL, new Long(new Date().getTime()));
        }
        if (this.badRecipientURL.containsKey(recipientURL) && (startTime = this.badRecipientURL.get(recipientURL)) + 1000L < new Date().getTime()) {
            this.badRecipientURL.remove(recipientURL);
            String subject = NetworkMessageSubjectType.DISCONNECT_CLIENT.getPattern();
            NetworkMessage message = new NetworkMessage(concernedMessage.getFrom(), concernedMessage.getReplyAddress(), subject, concernedMessage.getFrom());
            message.addRecipient(concernedMessage.getReplyAddress());
            this.sendMessage(message);
        }
    }

    private String getString(NetworkMessage msg) throws UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GraphService.write(msg, (OutputStream)out);
        return out.toString("UTF-8");
    }

    private class Postman
    extends Thread {
        private URL recipientURL;
        private String message;
        private HTTPSender parent;
        private NetworkMessage originalMsg;

        Postman(URL recipient, String message, HTTPSender parent, NetworkMessage originalMsg) {
            this.message = message;
            this.recipientURL = recipient;
            this.parent = parent;
            this.originalMsg = originalMsg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedWriter bw = null;
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)this.recipientURL.openConnection();
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                connection.connect();
                bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
                bw.write(this.message, 0, this.message.length());
                bw.flush();
                System.out.println("Code response =" + connection.getResponseCode());
            }
            catch (IOException e) {
                this.parent.registerBadRecipient(this.recipientURL, this.originalMsg);
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException iOException) {}
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }
}

