/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.activity;

import com.horstmann.violet.framework.diagram.BentStyle;
import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.SegmentedLineEdge;
import com.horstmann.violet.product.diagram.activity.DecisionNode;
import com.horstmann.violet.product.diagram.activity.SynchronizationBarNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class ActivityTransitionEdge
extends SegmentedLineEdge {
    private BentStyle bentStyle = BentStyle.VHV;

    public void setBentStyle(BentStyle newValue) {
        this.bentStyle = newValue;
    }

    public BentStyle getBentStyle() {
        return this.bentStyle;
    }

    @Override
    public ArrayList<Point2D> getPoints() {
        Rectangle2D startBounds = this.getStart().getBounds();
        Rectangle2D endBounds = this.getEnd().getBounds();
        ArrayList<Point2D> r = new ArrayList<Point2D>();
        if (this.getEnd() instanceof SynchronizationBarNode) {
            double endY;
            double startY = startBounds.getCenterY();
            Direction toEnd = startY >= (endY = endBounds.getCenterY()) ? Direction.NORTH : Direction.SOUTH;
            Point2D startPoint = this.getStart().getConnectionPoint(toEnd);
            r.add(startPoint);
            r.add(new Point2D.Double(startPoint.getX(), startY >= endY ? endBounds.getMaxY() : endBounds.getY()));
            return r;
        }
        if (this.getStart() instanceof SynchronizationBarNode) {
            double endY;
            double startY = startBounds.getCenterY();
            Direction toStart = startY >= (endY = endBounds.getCenterY()) ? Direction.SOUTH : Direction.NORTH;
            Point2D endPoint = this.getEnd().getConnectionPoint(toStart);
            r.add(new Point2D.Double(endPoint.getX(), startY >= endY ? startBounds.getY() : startBounds.getMaxY()));
            r.add(endPoint);
            return r;
        }
        if (this.getStart() instanceof DecisionNode) {
            return BentStyle.HV.getPath(startBounds, endBounds);
        }
        return this.bentStyle.getPath(startBounds, endBounds);
    }
}

