/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.activity;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.framework.diagram.RectangularNode;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SignalSendingNode
extends RectangularNode {
    private MultiLineString signal = new MultiLineString();
    private static int DEFAULT_WIDTH = 80;
    private static int DEFAULT_HEIGHT = 40;
    private static int EDGE_WIDTH = 20;

    public SignalSendingNode() {
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
    }

    @Override
    public boolean checkAddEdge(Edge e, Point2D p1, Point2D p2) {
        return e.getEnd() != null && this != e.getEnd();
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        g2.draw(this.getShape());
        this.signal.draw(g2, this.getTextBounds());
    }

    @Override
    public Shape getShape() {
        Rectangle2D b = this.getBounds();
        float x1 = (float)b.getX();
        float y1 = (float)b.getY();
        float x2 = x1 + (float)b.getWidth() - (float)EDGE_WIDTH;
        float y2 = y1;
        float x3 = x1 + (float)b.getWidth();
        float y3 = y1 + (float)b.getHeight() / 2.0f;
        float x4 = x2;
        float y4 = y1 + (float)b.getHeight();
        float x5 = x1;
        float y5 = y4;
        GeneralPath path = new GeneralPath();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        path.lineTo(x4, y4);
        path.lineTo(x5, y5);
        path.lineTo(x1, y1);
        return path;
    }

    private Rectangle2D getTextBounds() {
        Rectangle2D b = this.getBounds();
        return new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth() - (double)EDGE_WIDTH, b.getHeight());
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        Rectangle2D textBounds = this.signal.getBounds(g2);
        this.snapBounds(grid, Math.max(textBounds.getWidth(), (double)DEFAULT_WIDTH), Math.max(textBounds.getHeight(), (double)DEFAULT_HEIGHT));
    }

    public void setSignal(MultiLineString newValue) {
        this.signal = newValue;
    }

    public MultiLineString getSignal() {
        return this.signal;
    }
}

