/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.sequence;

import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.diagram.RectangularNode;
import com.horstmann.violet.product.diagram.common.PointNode;
import com.horstmann.violet.product.diagram.sequence.CallEdge;
import com.horstmann.violet.product.diagram.sequence.LifelineNode;
import com.horstmann.violet.product.diagram.sequence.ReturnEdge;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;

public class ActivationBarNode
extends RectangularNode {
    private LifelineNode lifeline;
    private boolean signaled;
    private boolean openBottom;
    private static int DEFAULT_WIDTH = 16;
    private static int DEFAULT_HEIGHT = 30;
    public static int CALL_YGAP = 20;

    public ActivationBarNode() {
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        Color oldColor = g2.getColor();
        g2.setColor(Color.WHITE);
        g2.fill(this.getBounds());
        g2.setColor(oldColor);
        if (this.openBottom) {
            Rectangle2D b = this.getBounds();
            double x1 = b.getX();
            double x2 = x1 + b.getWidth();
            double y1 = b.getY();
            double y3 = y1 + b.getHeight();
            double y2 = y3 - (double)CALL_YGAP;
            g2.draw(new Line2D.Double(x1, y1, x2, y1));
            g2.draw(new Line2D.Double(x1, y1, x1, y2));
            g2.draw(new Line2D.Double(x2, y1, x2, y2));
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{5.0f, 5.0f}, 0.0f));
            g2.draw(new Line2D.Double(x1, y2, x1, y3));
            g2.draw(new Line2D.Double(x2, y2, x2, y3));
            g2.setStroke(oldStroke);
        } else {
            g2.draw(this.getBounds());
        }
    }

    public LifelineNode getImplicitParameter() {
        return this.lifeline;
    }

    public void setImplicitParameter(LifelineNode newValue) {
        LifelineNode oldValue = this.lifeline;
        if (oldValue != newValue) {
            this.lifeline = newValue;
            Graph g = this.getGraph();
            if (g != null) {
                g.firePropertyChange(this, "implicitParameter", oldValue, newValue);
            }
        }
    }

    @Override
    public Point2D getConnectionPoint(Direction d) {
        if (d.getX() > 0.0) {
            return new Point2D.Double(this.getBounds().getMaxX(), this.getBounds().getMinY());
        }
        return new Point2D.Double(this.getBounds().getX(), this.getBounds().getMinY());
    }

    @Override
    public boolean checkAddEdge(Edge edge, Point2D startingNodePoint, Point2D endingNodePoint) {
        if (edge instanceof CallEdge) {
            int i;
            Node endingNode = edge.getEnd();
            if (!(endingNode instanceof ActivationBarNode) && !(endingNode instanceof LifelineNode)) {
                return false;
            }
            if (endingNode instanceof LifelineNode && ((LifelineNode)endingNode).getTopRectangle().contains(endingNodePoint)) {
                if (endingNode == this.getImplicitParameter()) {
                    return false;
                }
                edge.connect(this, endingNode);
                CallEdge callEdge = (CallEdge)edge;
                String oldValue = callEdge.getMiddleLabel();
                callEdge.setMiddleLabel("\u00abcreate\u00bb");
                this.getGraph().firePropertyChange(callEdge, "middleLabel", oldValue, callEdge.getMiddleLabel());
                this.addChild(this.getChildren().size(), endingNode);
                return true;
            }
            if (endingNode instanceof ActivationBarNode && (endingNode.getParent() != null || this.getAncestors().contains(endingNode))) {
                endingNode = ((ActivationBarNode)endingNode).getImplicitParameter();
            }
            if (endingNode == null) {
                return false;
            }
            if (endingNode instanceof LifelineNode) {
                ActivationBarNode newNode = new ActivationBarNode();
                this.getGraph().addNode(newNode, endingNodePoint);
                newNode.setImplicitParameter((LifelineNode)endingNode);
                this.getGraph().firePropertyChange(newNode, "implicitParameter", null, endingNode);
                endingNode = newNode;
            }
            edge.connect(this, endingNode);
            List<Node> children = this.getChildren();
            for (i = 0; i < children.size() && children.get(i).getLocation().getY() < startingNodePoint.getY(); ++i) {
            }
            this.addChild(i, endingNode);
            return true;
        }
        if (edge instanceof ReturnEdge) {
            Node endingNode = this.getParent();
            if (endingNode == null) {
                return false;
            }
            if (endingNode instanceof ActivationBarNode) {
                edge.connect(this, endingNode);
                return true;
            }
        }
        return false;
    }

    @Override
    public void checkRemoveEdge(Edge e) {
        if (e.getStart() == this) {
            this.removeChild(e.getEnd());
        }
    }

    @Override
    public void checkRemoveNode(Node n) {
        if (n == this.lifeline) {
            this.getGraph().removeNodesAndEdges(Arrays.asList(this), null);
        }
    }

    private Edge findEdge(Node start, Node end) {
        for (Edge e : this.getGraph().getEdges()) {
            if (e.getStart() != start || e.getEnd() != end) continue;
            return e;
        }
        return null;
    }

    @Override
    public void setBounds(Rectangle2D newBounds) {
        super.setBounds(newBounds);
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        if (this.getImplicitParameter() == null) {
            return;
        }
        double xmid = this.lifeline.getBounds().getCenterX() - (double)(DEFAULT_WIDTH / 2);
        for (ActivationBarNode n = (ActivationBarNode)this.getParent(); n != null; n = (ActivationBarNode)n.getParent()) {
            if (n.lifeline != this.lifeline) continue;
            xmid += (double)(DEFAULT_WIDTH / 2);
        }
        this.translate(xmid - this.getLocation().getX(), 0.0);
        double ytop = this.getLocation().getY() + (double)CALL_YGAP;
        List<Node> calls = this.getChildren();
        for (Node n : calls) {
            if (n instanceof ActivationBarNode) {
                n.setZ(this.getZ() + 1);
            } else {
                n.setZ(0);
            }
            Edge callEdge = this.findEdge(this, n);
            if (callEdge != null) {
                ytop += callEdge.getBounds(g2).getHeight() - (double)CALL_YGAP;
            }
            if (n instanceof LifelineNode) {
                n.translate(0.0, ytop - ((LifelineNode)n).getTopRectangle().getHeight() / 2.0 - n.getLocation().getY());
            } else {
                n.translate(0.0, ytop - n.getLocation().getY());
            }
            n.layout(g2, grid);
            if (n instanceof ActivationBarNode && ((ActivationBarNode)n).signaled) {
                ytop += (double)CALL_YGAP;
                continue;
            }
            if (n instanceof ActivationBarNode) {
                ytop += n.getBounds().getHeight() + (double)CALL_YGAP;
                continue;
            }
            if (!(n instanceof LifelineNode)) continue;
            ytop += ((LifelineNode)n).getTopRectangle().getHeight() / 2.0 + (double)CALL_YGAP;
        }
        if (this.openBottom) {
            ytop += (double)(2 * CALL_YGAP);
        }
        double minHeight = DEFAULT_HEIGHT;
        Edge returnEdge = this.findEdge(this, this.getParent());
        if (returnEdge != null) {
            minHeight = Math.max(minHeight, returnEdge.getBounds(g2).getHeight());
        }
        this.setBounds(new Rectangle2D.Double(this.getLocation().getX(), this.getLocation().getY(), DEFAULT_WIDTH, Math.max(minHeight, ytop - this.getLocation().getY())));
    }

    @Override
    public boolean checkAddNode(Node n, Point2D p) {
        return n instanceof PointNode;
    }

    public void setSignaled(boolean newValue) {
        this.signaled = newValue;
    }

    public boolean isOpenBottom() {
        return this.openBottom;
    }

    public void setOpenBottom(boolean newValue) {
        this.openBottom = newValue;
    }
}

