/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.usecase;

import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.framework.diagram.RectangularNode;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class ActorNode
extends RectangularNode {
    private MultiLineString name = new MultiLineString();
    private static int DEFAULT_WIDTH = 48;
    private static int DEFAULT_HEIGHT = 64;
    private static int GAP_ABOVE = 4;
    private static int HEAD_SIZE = DEFAULT_WIDTH * 4 / 12;
    private static int BODY_SIZE = DEFAULT_WIDTH * 5 / 12;
    private static int LEG_SIZE = DEFAULT_WIDTH * 5 / 12;
    private static int ARMS_SIZE = DEFAULT_WIDTH * 6 / 12;

    public ActorNode() {
        this.name.setText("Actor");
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        Rectangle2D.Double top = new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
        Rectangle2D bot = this.name.getBounds(g2);
        this.snapBounds(grid, Math.max(((RectangularShape)top).getWidth(), bot.getWidth()), ((RectangularShape)top).getHeight() + bot.getHeight());
    }

    @Override
    public void draw(Graphics2D g2) {
        Rectangle2D bounds = this.getBounds();
        GeneralPath path = new GeneralPath();
        float neckX = (float)(bounds.getX() + bounds.getWidth() / 2.0);
        float neckY = (float)(bounds.getY() + (double)HEAD_SIZE + (double)GAP_ABOVE);
        path.moveTo(neckX, neckY);
        path.quadTo(neckX + (float)(HEAD_SIZE / 2), neckY, neckX + (float)(HEAD_SIZE / 2), neckY - (float)(HEAD_SIZE / 2));
        path.quadTo(neckX + (float)(HEAD_SIZE / 2), neckY - (float)HEAD_SIZE, neckX, neckY - (float)HEAD_SIZE);
        path.quadTo(neckX - (float)(HEAD_SIZE / 2), neckY - (float)HEAD_SIZE, neckX - (float)(HEAD_SIZE / 2), neckY - (float)(HEAD_SIZE / 2));
        path.quadTo(neckX - (float)(HEAD_SIZE / 2), neckY, neckX, neckY);
        float hipX = neckX;
        float hipY = neckY + (float)BODY_SIZE;
        path.lineTo(hipX, hipY);
        path.moveTo(neckX - (float)(ARMS_SIZE / 2), neckY + (float)(BODY_SIZE / 3));
        path.lineTo(neckX + (float)(ARMS_SIZE / 2), neckY + (float)(BODY_SIZE / 3));
        float dx = (float)((double)LEG_SIZE / Math.sqrt(2.0));
        float feetX1 = hipX - dx;
        float feetX2 = hipX + dx + 1.0f;
        float feetY = hipY + dx + 1.0f;
        path.moveTo(feetX1, feetY);
        path.lineTo(hipX, hipY);
        path.lineTo(feetX2, feetY);
        g2.draw(path);
        Rectangle2D bot = this.name.getBounds(g2);
        Rectangle2D.Double namebox = new Rectangle2D.Double(bounds.getX() + (bounds.getWidth() - bot.getWidth()) / 2.0, bounds.getY() + (double)DEFAULT_HEIGHT, bot.getWidth(), bot.getHeight());
        this.name.draw(g2, namebox);
    }

    public void setName(MultiLineString newValue) {
        this.name = newValue;
    }

    public MultiLineString getName() {
        return this.name;
    }

    @Override
    public ActorNode clone() {
        ActorNode cloned = (ActorNode)super.clone();
        cloned.name = this.name.clone();
        return cloned;
    }
}

