/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ws.jaxme.js.JavaQName;

public class JavaQNameImpl {
    private static final Map names = new HashMap();
    public static final JavaQName VOID = new PrimitiveImpl(Void.TYPE.getName(), null, null);
    public static final JavaQName BOOLEAN = new PrimitiveImpl(Boolean.TYPE.getName(), JavaQNameImpl.getInstance(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaQNameImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean), "booleanValue()");
    public static final JavaQName BYTE = new PrimitiveImpl(Byte.TYPE.getName(), JavaQNameImpl.getInstance(class$java$lang$Byte == null ? (class$java$lang$Byte = JavaQNameImpl.class$("java.lang.Byte")) : class$java$lang$Byte), "byteValue");
    public static final JavaQName SHORT = new PrimitiveImpl(Short.TYPE.getName(), JavaQNameImpl.getInstance(class$java$lang$Short == null ? (class$java$lang$Short = JavaQNameImpl.class$("java.lang.Short")) : class$java$lang$Short), "shortValue");
    public static final JavaQName INT = new PrimitiveImpl(Integer.TYPE.getName(), JavaQNameImpl.getInstance(class$java$lang$Integer == null ? (class$java$lang$Integer = JavaQNameImpl.class$("java.lang.Integer")) : class$java$lang$Integer), "intValue");
    public static final JavaQName LONG = new PrimitiveImpl(Long.TYPE.getName(), JavaQNameImpl.getInstance(class$java$lang$Long == null ? (class$java$lang$Long = JavaQNameImpl.class$("java.lang.Long")) : class$java$lang$Long), "longValue");
    public static final JavaQName FLOAT = new PrimitiveImpl(Float.TYPE.getName(), JavaQNameImpl.getInstance(class$java$lang$Float == null ? (class$java$lang$Float = JavaQNameImpl.class$("java.lang.Float")) : class$java$lang$Float), "floatValue");
    public static final JavaQName DOUBLE = new PrimitiveImpl(Double.TYPE.getName(), JavaQNameImpl.getInstance(class$java$lang$Double == null ? (class$java$lang$Double = JavaQNameImpl.class$("java.lang.Double")) : class$java$lang$Double), "doubleValue");
    public static final JavaQName CHAR = new PrimitiveImpl(Character.TYPE.getName(), JavaQNameImpl.getInstance(class$java$lang$Character == null ? (class$java$lang$Character = JavaQNameImpl.class$("java.lang.Character")) : class$java$lang$Character), "charValue");
    private static final JavaQName[] primitives = new JavaQName[]{VOID, BOOLEAN, BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, CHAR};
    private static final Class[] primitiveClasses = new Class[]{Void.TYPE, Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE};
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;

    public static JavaQName getInstance(Class pClass) {
        if (pClass.isArray()) {
            return JavaQNameImpl.getArray(JavaQNameImpl.getInstance(pClass.getComponentType()));
        }
        if (pClass.isPrimitive()) {
            for (int i = 0; i < primitives.length; ++i) {
                if (!primitiveClasses[i].equals(pClass)) continue;
                return primitives[i];
            }
            throw new IllegalArgumentException("Unknown primitive type: " + pClass.getClass().getName());
        }
        if (Void.TYPE.equals(pClass)) {
            return VOID;
        }
        String name = pClass.getName();
        int offset = name.lastIndexOf(46);
        if (offset == -1) {
            return JavaQNameImpl.getInstance(null, name);
        }
        return JavaQNameImpl.getInstance(name.substring(0, offset), name.substring(offset + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaQName getInstance(String pPackageName, String pClassName) {
        JavaQName result;
        String name;
        if (pClassName == null || pClassName.length() == 0) {
            throw new NullPointerException("The class name must not be null or empty.");
        }
        if (pPackageName == null || pPackageName.length() == 0) {
            for (int i = 0; i < primitives.length; ++i) {
                if (!primitiveClasses[i].getName().equals(pClassName)) continue;
                return primitives[i];
            }
            name = pClassName;
            pPackageName = "";
        } else {
            name = pPackageName + "." + pClassName;
        }
        Map map = names;
        synchronized (map) {
            result = (JavaQName)names.get(name);
            if (result == null) {
                if (pClassName.endsWith("[]")) {
                    String instanceClassName = pClassName.substring(0, pClassName.length() - 2);
                    JavaQName instanceClass = JavaQNameImpl.getInstance(pPackageName, instanceClassName);
                    result = new ArrayImpl(instanceClass);
                } else {
                    result = new StandardImpl(pPackageName, pClassName);
                }
                names.put(name, result);
            }
        }
        return result;
    }

    public static JavaQName getInstance(String pClassName) {
        int offset = pClassName.lastIndexOf(46);
        if (offset == -1) {
            return JavaQNameImpl.getInstance(null, pClassName);
        }
        return JavaQNameImpl.getInstance(pClassName.substring(0, offset), pClassName.substring(offset + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaQName getArray(JavaQName pQName) {
        JavaQName result;
        String name = pQName.toString() + "[]";
        Map map = names;
        synchronized (map) {
            result = (JavaQName)names.get(name);
            if (result == null) {
                result = new ArrayImpl(pQName);
                names.put(name, result);
            }
        }
        return result;
    }

    public static JavaQName getInnerInstance(JavaQName pQName, String pInnerClassName) {
        return JavaQNameImpl.getInstance(pQName.getPackageName(), pQName.getClassName() + "$" + pInnerClassName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ArrayImpl
    extends DefaultImpl {
        private JavaQName qName;

        public ArrayImpl(JavaQName pQName) {
            this.qName = pQName;
        }

        public String getPackageName() {
            return this.qName.getPackageName();
        }

        public String getClassName() {
            return this.qName.getClassName();
        }

        public boolean isArray() {
            return true;
        }

        public boolean isImportable() {
            return false;
        }

        public boolean isPrimitive() {
            return false;
        }

        public JavaQName getInstanceClass() {
            return this.qName;
        }

        public String toString() {
            return this.qName.toString() + "[]";
        }

        public String getOuterClassName() {
            return null;
        }

        public String getInnerClassName() {
            return this.qName.getClassName();
        }

        public boolean isInnerClass() {
            return false;
        }

        public JavaQName getObjectType() {
            return null;
        }

        public String getPrimitiveConversionMethod() {
            return null;
        }
    }

    private static class PrimitiveImpl
    extends StandardImpl {
        private final JavaQName objectType;
        private final String primitiveConversionMethod;

        public PrimitiveImpl(String pClassName, JavaQName pObjectType, String pConversionMethod) {
            super("", pClassName);
            this.objectType = pObjectType;
            this.primitiveConversionMethod = pConversionMethod;
        }

        public boolean isImportable() {
            return false;
        }

        public boolean isPrimitive() {
            return true;
        }

        public void checkPackageName() {
        }

        public String toString() {
            return this.getClassName();
        }

        public JavaQName getObjectType() {
            return this.objectType;
        }

        public String getPrimitiveConversionMethod() {
            return this.primitiveConversionMethod;
        }
    }

    private static class StandardImpl
    extends DefaultImpl {
        private String packageName;
        private String className;

        public StandardImpl(String pPackageName, String pClassName) {
            this.checkPackageName(pPackageName);
            this.packageName = pPackageName;
            this.className = pClassName;
        }

        protected void checkPackageName(String pPackageName) {
            StringTokenizer st = new StringTokenizer(pPackageName, ".");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.length() == 0) {
                    throw new IllegalArgumentException("Invalid package name: " + pPackageName);
                }
                for (int i = 0; i < tok.length(); ++i) {
                    char c = tok.charAt(i);
                    if ((i != 0 || Character.isJavaIdentifierStart(c)) && (i <= 0 || Character.isJavaIdentifierPart(c))) continue;
                    throw new IllegalArgumentException("Invalid package name: " + pPackageName);
                }
            }
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isArray() {
            return false;
        }

        public JavaQName getInstanceClass() {
            throw new IllegalStateException("The class " + this + "is not an array class.");
        }

        public boolean isImportable() {
            return true;
        }

        public boolean isPrimitive() {
            return false;
        }

        public String toString() {
            String c = this.getClassName();
            String p = this.getPackageName();
            return p.length() > 0 ? p + "." + c : c;
        }

        public String getOuterClassName() {
            int offset = this.className.lastIndexOf(36);
            if (offset == -1) {
                return null;
            }
            return this.className.substring(0, offset);
        }

        public String getInnerClassName() {
            int offset = this.className.lastIndexOf(36);
            if (offset == -1) {
                return this.className;
            }
            return this.className.substring(offset + 1);
        }

        public boolean isInnerClass() {
            return this.className.indexOf(36) > 0;
        }

        public JavaQName getObjectType() {
            return null;
        }

        public String getPrimitiveConversionMethod() {
            return null;
        }
    }

    private static abstract class DefaultImpl
    implements JavaQName {
        private DefaultImpl() {
        }

        public int compareTo(Object pOther) {
            JavaQName other = (JavaQName)pOther;
            if (this.isArray()) {
                if (!other.isArray()) {
                    return -1;
                }
                return this.getInstanceClass().compareTo(other.getInstanceClass());
            }
            if (other.isArray()) {
                return 1;
            }
            int result = this.getPackageName().compareTo(other.getPackageName());
            if (result != 0) {
                return result;
            }
            result = this.getClassName().compareTo(other.getClassName());
            if (result != 0) {
                return result;
            }
            return 0;
        }

        public int hashCode() {
            return this.getPackageName().hashCode() + this.getClassName().hashCode();
        }

        public boolean equals(Object pOther) {
            if (pOther == null || !(pOther instanceof JavaQName)) {
                return false;
            }
            return this.compareTo(pOther) == 0;
        }
    }
}

