/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.TextFile;
import org.apache.ws.jaxme.js.apps.JavaSourceResolver;
import org.apache.ws.jaxme.js.impl.TextFileImpl;
import org.apache.ws.jaxme.logging.Logger;
import org.apache.ws.jaxme.logging.LoggerAccess;

public class JavaSourceFactory
implements JavaSourceResolver {
    private Logger logger = LoggerAccess.getLogger(class$org$apache$ws$jaxme$js$JavaSourceFactory == null ? (class$org$apache$ws$jaxme$js$JavaSourceFactory = JavaSourceFactory.class$("org.apache.ws.jaxme.js.JavaSourceFactory")) : class$org$apache$ws$jaxme$js$JavaSourceFactory);
    private boolean overwriteForced;
    private boolean settingReadOnly;
    private Map sources = new HashMap();
    private List files = new ArrayList();
    static /* synthetic */ Class class$org$apache$ws$jaxme$js$JavaSourceFactory;

    public void setLogger(Logger pLogger) {
        this.logger = pLogger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setSettingReadOnly(boolean pSettingReadOnly) {
        this.settingReadOnly = pSettingReadOnly;
    }

    public boolean isSettingReadOnly() {
        return this.settingReadOnly;
    }

    public void setOverwriteForced(boolean pOverwriteForced) {
        this.overwriteForced = pOverwriteForced;
    }

    public boolean isOverwriteForced() {
        return this.overwriteForced;
    }

    public JavaSource newJavaSource(JavaQName pName) {
        return this.newJavaSource(pName, JavaSource.DEFAULT_PROTECTION);
    }

    public JavaSource newJavaSource(JavaQName pName, JavaSource.Protection pProtection) {
        if (this.sources.containsKey(pName)) {
            throw new IllegalStateException("The class " + pName + " has already been created.");
        }
        JavaSource result = new JavaSource(this, pName, pProtection);
        this.sources.put(pName, result);
        return result;
    }

    public JavaSource newJavaSource(JavaQName pName, String pProtection) {
        return this.newJavaSource(pName, JavaSource.Protection.valueOf(pProtection));
    }

    public Iterator getJavaSources() {
        return this.sources.values().iterator();
    }

    public Iterator getTextFiles() {
        return this.files.iterator();
    }

    public JavaSource getJavaSource(JavaQName pName) {
        return (JavaSource)this.sources.get(pName);
    }

    public TextFile getTextFile(String pPackageName, String pFileName) {
        Iterator iter = this.files.iterator();
        while (iter.hasNext()) {
            TextFile textFile = (TextFile)iter.next();
            if (!textFile.getPackageName().equals(pPackageName) || !textFile.getFileName().equals(pFileName)) continue;
            return textFile;
        }
        return null;
    }

    public File getPackageDirectory(File pBaseDir, String pPackageName) {
        if (pPackageName != null) {
            StringTokenizer st = new StringTokenizer(pPackageName, ".");
            while (st.hasMoreTokens()) {
                String dir = st.nextToken();
                pBaseDir = new File(pBaseDir, dir);
            }
        }
        return pBaseDir;
    }

    public File getSourceFile(File pBaseDir, JavaQName pQName) {
        if (pQName == null) {
            throw new NullPointerException("The class name must not be null.");
        }
        File packageDirectory = this.getPackageDirectory(pBaseDir, pQName.getPackageName());
        String name = pQName.getClassName();
        int offset = name.indexOf(46);
        if (offset != -1) {
            throw new IllegalArgumentException("Source files must not be generated for inner classes: " + name);
        }
        offset = name.indexOf(46);
        if (offset != -1) {
            throw new IllegalArgumentException("Source files must not be generated for inner classes: " + name);
        }
        return new File(packageDirectory, name + ".java");
    }

    public File getLocation(File pBaseDir, String pPackage) {
        StringTokenizer st = new StringTokenizer(pPackage, ".");
        while (st.hasMoreTokens()) {
            pBaseDir = new File(pBaseDir, st.nextToken());
        }
        return pBaseDir;
    }

    public File getLocation(File pBaseDir, JavaSource pJs) {
        if (pJs.isInnerClass()) {
            throw new IllegalArgumentException("Inner classes have no assigned location in the file system.");
        }
        return new File(this.getLocation(pBaseDir, pJs.getPackageName()), pJs.getClassName() + ".java");
    }

    public File getLocation(File pBaseDir, TextFile pTextFile) {
        return new File(this.getLocation(pBaseDir, pTextFile.getPackageName()), pTextFile.getFileName());
    }

    protected boolean isSameFile(JavaSource pJs, File pFile) throws IOException {
        StringWriter sw = new StringWriter();
        pJs.write(sw);
        sw.close();
        return this.isSameFile(sw.toString(), pFile);
    }

    protected boolean isSameFile(String pContents, File pFile) throws IOException {
        int len;
        FileReader r = new FileReader(pFile);
        StringWriter sw = new StringWriter();
        char[] buffer = new char[4096];
        while ((len = r.read(buffer)) != -1) {
            if (len <= 0) continue;
            sw.write(buffer, 0, len);
        }
        return this.isSameFile(pContents, sw.toString());
    }

    protected boolean isSameFile(String pContents1, String pContents2) {
        return pContents1.equals(pContents2);
    }

    protected void writeFile(File pFile, JavaSource pJs) throws IOException {
        String mName = "writeFile(File,JavaSource)";
        File p = pFile.getParentFile();
        if (p != null && !p.exists()) {
            this.getLogger().fine("writeFile(File,JavaSource)", "Creating directory " + p);
            p.mkdirs();
        }
        if (this.isOverwriteForced() || !pFile.exists() || !this.isSameFile(pJs, pFile)) {
            this.getLogger().fine("writeFile(File,JavaSource)", "Creating " + pFile);
            BufferedWriter w = new BufferedWriter(new FileWriter(pFile), 4096);
            pJs.write(w);
            ((Writer)w).close();
            if (this.isSettingReadOnly()) {
                pFile.setReadOnly();
            }
        } else {
            this.getLogger().fine("writeFile(File,JavaSource)", "Uptodate: " + pFile);
        }
    }

    protected void writeFile(File pFile, String pContents) throws IOException {
        String mName = "writeFile(File,String)";
        File p = pFile.getParentFile();
        if (p != null && !p.exists()) {
            this.getLogger().fine("writeFile(File,String)", "Creating directory " + p);
            p.mkdirs();
        }
        if (this.isOverwriteForced() || !pFile.exists() || !this.isSameFile(pContents, pFile)) {
            this.getLogger().fine("writeFile(File,String)", "Creating " + pFile);
            BufferedWriter w = new BufferedWriter(new FileWriter(pFile), 4096);
            w.write(pContents);
            ((Writer)w).close();
            if (this.isSettingReadOnly()) {
                pFile.setReadOnly();
            }
        } else {
            this.getLogger().fine("writeFile(File,String)", "Uptodate: " + pFile);
        }
    }

    public void write(File pBaseDir, JavaSource pJs) throws IOException {
        this.writeFile(this.getLocation(pBaseDir, pJs), pJs);
    }

    public void write(File pBaseDir, TextFile pFile) throws IOException {
        this.writeFile(this.getLocation(pBaseDir, pFile), pFile.getContents());
    }

    public void write(File pBaseDir) throws IOException {
        Iterator iter = this.getJavaSources();
        while (iter.hasNext()) {
            this.write(pBaseDir, (JavaSource)iter.next());
        }
        iter = this.getTextFiles();
        while (iter.hasNext()) {
            this.write(pBaseDir, (TextFile)iter.next());
        }
    }

    public TextFile newTextFile(String pPackageName, String pFileName) {
        Iterator<Object> iter = this.files.iterator();
        while (iter.hasNext()) {
            TextFile f = (TextFile)iter.next();
            if (!f.getPackageName().equals(pPackageName) || !f.getFileName().equals(pFileName)) continue;
            throw new IllegalStateException("A file named " + pFileName + " in package " + pPackageName + " already exists.");
        }
        iter = this.sources.keySet().iterator();
        while (iter.hasNext()) {
            JavaQName qName = (JavaQName)iter.next();
            if (!qName.getPackageName().equals(pPackageName) || !(qName.getClassName() + ".java").equals(pFileName)) continue;
            throw new IllegalStateException("A Java source file names " + pFileName + " in package " + pPackageName + " already exists.");
        }
        TextFileImpl result = new TextFileImpl(pPackageName, pFileName);
        this.files.add(result);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

