/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.SQLFactory;
import org.apache.ws.jaxme.sqls.SetStatement;
import org.apache.ws.jaxme.sqls.Value;
import org.apache.ws.jaxme.sqls.impl.StatementImpl;
import org.apache.ws.jaxme.sqls.impl.ValueImpl;

public abstract class SetStatementImpl
extends StatementImpl
implements SetStatement {
    private List setValues = new ArrayList();

    protected SetStatementImpl(SQLFactory pFactory) {
        super(pFactory);
    }

    public Iterator getSetValues() {
        return this.setValues.iterator();
    }

    public void addSet(ColumnReference pColumn, Value pValue) {
        this.addSet(pColumn, pValue);
    }

    protected void addSet(ColumnReference pRef, Object pValue) {
        if (!pRef.getTableReference().equals(this.getTableReference())) {
            throw new IllegalArgumentException("The column has an invalid table reference.");
        }
        this.setValues.add(new SetValueImpl(pRef, pValue));
    }

    public void addSet(Column pColumn, Object pValue) {
        this.addSet(this.getTableReference().newColumnReference(pColumn), pValue);
    }

    public void addSet(String pColumn, Object pValue) {
        this.addSet(this.getTableReference().newColumnReference(pColumn), pValue);
    }

    public void addSet(Column.Name pColumn, Object pValue) {
        this.addSet(this.getTableReference().newColumnReference(pColumn), pValue);
    }

    public void addSet(Column pColumn, Value pValue) {
        this.addSet(pColumn, (Object)pValue);
    }

    public void addSet(Column.Name pColumn, Value pValue) {
        this.addSet(this.getTableReference().newColumnReference(pColumn), (Object)pValue);
    }

    public void addSet(String pColumn, Value pValue) {
        this.addSet(this.getTableReference().newColumnReference(pColumn), (Object)pValue);
    }

    public void addSetNull(Column pColumn) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.NULL, null));
    }

    public void addSetNull(Column.Name pColumn) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.NULL, null));
    }

    public void addSetNull(String pColumn) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.NULL, null));
    }

    public void addSet(Column pColumn) {
        if (pColumn == null) {
            throw new NullPointerException("The column being set must not be null.");
        }
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.PLACEHOLDER, null));
    }

    public void addSet(Column.Name pColumn) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.PLACEHOLDER, null));
    }

    public void addSet(String pColumn) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.PLACEHOLDER, null));
    }

    public void addSet(Column pColumn, byte pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.BYTE, new Byte(pValue)));
    }

    public void addSet(Column.Name pColumn, byte pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.BYTE, new Byte(pValue)));
    }

    public void addSet(String pColumn, byte pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.BYTE, new Byte(pValue)));
    }

    public void addSet(Column pColumn, short pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.SHORT, new Short(pValue)));
    }

    public void addSet(Column.Name pColumn, short pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.SHORT, new Short(pValue)));
    }

    public void addSet(String pColumn, short pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.SHORT, new Short(pValue)));
    }

    public void addSet(Column pColumn, int pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.INT, new Integer(pValue)));
    }

    public void addSet(Column.Name pColumn, int pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.INT, new Integer(pValue)));
    }

    public void addSet(String pColumn, int pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.INT, new Integer(pValue)));
    }

    public void addSet(Column pColumn, long pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.LONG, new Long(pValue)));
    }

    public void addSet(Column.Name pColumn, long pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.LONG, new Long(pValue)));
    }

    public void addSet(String pColumn, long pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.LONG, new Long(pValue)));
    }

    public void addSet(Column pColumn, float pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.FLOAT, new Float(pValue)));
    }

    public void addSet(Column.Name pColumn, float pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.FLOAT, new Float(pValue)));
    }

    public void addSet(String pColumn, float pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.FLOAT, new Float(pValue)));
    }

    public void addSet(Column pColumn, boolean pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.BOOLEAN, pValue ? Boolean.TRUE : Boolean.FALSE));
    }

    public void addSet(Column.Name pColumn, boolean pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.BOOLEAN, pValue ? Boolean.TRUE : Boolean.FALSE));
    }

    public void addSet(String pColumn, boolean pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.BOOLEAN, pValue ? Boolean.TRUE : Boolean.FALSE));
    }

    public void addSet(Column pColumn, String pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.STRING, pValue));
    }

    public void addSet(Column.Name pColumn, String pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.STRING, pValue));
    }

    public void addSet(String pColumn, String pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.STRING, pValue));
    }

    public void addSetDateTime(Column pColumn, Calendar pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.DATETIME, pValue));
    }

    public void addSetDateTime(Column.Name pColumn, Calendar pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.DATETIME, pValue));
    }

    public void addSetDateTime(String pColumn, Calendar pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.DATETIME, pValue));
    }

    public void addSetTime(Column pColumn, Calendar pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.TIME, pValue));
    }

    public void addSetTime(Column.Name pColumn, Calendar pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.TIME, pValue));
    }

    public void addSetTime(String pColumn, Calendar pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.TIME, pValue));
    }

    public void addSetDate(Column pColumn, Calendar pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.DATE, pValue));
    }

    public void addSetDate(Column.Name pColumn, Calendar pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.DATE, pValue));
    }

    public void addSetDate(String pColumn, Calendar pValue) {
        this.addSet(pColumn, (Value)new ValueImpl(Value.Type.DATE, pValue));
    }

    public static class SetValueImpl
    implements SetStatement.SetValue {
        private final ColumnReference columnReference;
        private final Object value;

        public SetValueImpl(ColumnReference pColumn, Object pValue) {
            if (pColumn == null) {
                throw new NullPointerException("Column reference must not be null.");
            }
            if (pValue == null) {
                throw new NullPointerException("Value must not be null.");
            }
            this.columnReference = pColumn;
            this.value = pValue;
        }

        public ColumnReference getColumnReference() {
            return this.columnReference;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

