/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.eclipseplugin.editors;

import com.horstmann.violet.eclipseplugin.tools.JavaFileModel;
import com.horstmann.violet.framework.diagram.DiagramLink;
import com.horstmann.violet.framework.diagram.RectangularNode;
import com.horstmann.violet.framework.gui.GraphPanel;
import com.horstmann.violet.product.diagram.classes.ClassDiagramGraph;
import com.horstmann.violet.product.diagram.common.DiagramLinkNode;
import com.horstmann.violet.product.diagram.sequence.SequenceDiagramGraph;
import java.awt.Point;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;

public class FileDropTargetListener
implements DropTargetListener {
    private static final String JAVA_FILE_EXTENSION = "java";
    private static final String VIOLET_FILE_EXTENSION = "violet";
    private GraphPanel UMLGraphPanel;

    public FileDropTargetListener(GraphPanel graphPanel) {
        this.UMLGraphPanel = graphPanel;
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        Point UMLGraphPanelLocationOnScreen = this.UMLGraphPanel.getLocationOnScreen();
        Point mouseLocationOnUMLGraphPanel = new Point(event.x - UMLGraphPanelLocationOnScreen.x, event.y - UMLGraphPanelLocationOnScreen.y);
        Object dropObject = event.data;
        if (dropObject != null && dropObject instanceof IResource[]) {
            IResource rs = ((IResource[])dropObject)[0];
            this.UMLGraphPanel.repaint();
            if (VIOLET_FILE_EXTENSION.equals(rs.getFileExtension().toLowerCase())) {
                this.addVioletLinkNode(event, mouseLocationOnUMLGraphPanel, rs);
                return;
            }
            if (JAVA_FILE_EXTENSION.equals(rs.getFileExtension().toLowerCase())) {
                this.importJavaFile(event, mouseLocationOnUMLGraphPanel, rs);
                return;
            }
        }
        event.detail = 0;
    }

    private void importJavaFile(DropTargetEvent event, Point mouseLocationOnUMLGraphPanel, IResource rs) {
        event.detail = 4;
        File javaFile = rs.getLocation().toFile();
        JavaFileModel jfm = new JavaFileModel(javaFile);
        RectangularNode node = null;
        boolean added = false;
        if (this.UMLGraphPanel.getGraph().getClass().equals(ClassDiagramGraph.class)) {
            node = jfm.getClassNode();
            added = this.UMLGraphPanel.addNodeAtPoint(node, mouseLocationOnUMLGraphPanel);
        }
        if (this.UMLGraphPanel.getGraph().getClass().equals(SequenceDiagramGraph.class)) {
            node = jfm.getLifelineNode();
            added = this.UMLGraphPanel.addNodeAtPoint(node, mouseLocationOnUMLGraphPanel);
        }
        if (added) {
            this.UMLGraphPanel.setSelectedElement(node);
            this.UMLGraphPanel.repaint();
        }
    }

    private void addVioletLinkNode(DropTargetEvent event, Point mouseLocationOnUMLGraphPanel, IResource rs) {
        event.detail = 4;
        File violetFile = rs.getLocation().toFile();
        DiagramLink link = new DiagramLink();
        try {
            link.setURL(violetFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        DiagramLinkNode linkNode = new DiagramLinkNode();
        linkNode.setDiagramLink(link);
        boolean added = this.UMLGraphPanel.addNodeAtPoint(linkNode, mouseLocationOnUMLGraphPanel);
        if (added) {
            this.UMLGraphPanel.setSelectedElement(linkNode);
            this.UMLGraphPanel.repaint();
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

