/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.action;

import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.DialogFactory;
import com.horstmann.violet.framework.gui.EditorFrame;
import com.horstmann.violet.framework.gui.GraphPanel;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class ViewAction {
    private static final double GROW_SCALE_FACTOR = Math.sqrt(2.0);

    public void zoomOut(DiagramPanel diagramPanel) {
        if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
            return;
        }
        GraphPanel panel = diagramPanel.getGraphPanel();
        panel.changeZoom(-1);
    }

    public void zoomIn(DiagramPanel diagramPanel) {
        if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
            return;
        }
        GraphPanel panel = diagramPanel.getGraphPanel();
        panel.changeZoom(1);
    }

    public void growDrawingArea(DiagramPanel diagramPanel) {
        if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
            return;
        }
        Graph g = diagramPanel.getGraphPanel().getGraph();
        Rectangle2D bounds = g.getBounds((Graphics2D)diagramPanel.getGraphics());
        bounds.add(diagramPanel.getGraphPanel().getBounds());
        g.setMinBounds(new Rectangle2D.Double(0.0, 0.0, GROW_SCALE_FACTOR * bounds.getWidth(), GROW_SCALE_FACTOR * bounds.getHeight()));
        diagramPanel.getGraphPanel().revalidate();
        diagramPanel.repaint();
    }

    public void clipDrawingArea(DiagramPanel diagramPanel) {
        if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
            return;
        }
        Graph g = diagramPanel.getGraphPanel().getGraph();
        g.setMinBounds(null);
        diagramPanel.getGraphPanel().revalidate();
        diagramPanel.repaint();
    }

    public void displaySmallerGrid(DiagramPanel diagramPanel) {
        if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
            return;
        }
        GraphPanel panel = diagramPanel.getGraphPanel();
        panel.changeGridSize(-1);
    }

    public void displayLargerGrid(DiagramPanel diagramPanel) {
        if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
            return;
        }
        GraphPanel panel = diagramPanel.getGraphPanel();
        panel.changeGridSize(1);
    }

    public void hideGrid(DiagramPanel diagramPanel, boolean isHidden) {
        if (diagramPanel == null || diagramPanel.getGraphPanel() == null || diagramPanel.getGraphPanel().getGraph() == null) {
            return;
        }
        GraphPanel panel = diagramPanel.getGraphPanel();
        panel.setHideGrid(isHidden);
    }

    public void changeLookAndFeel(String className, EditorFrame editorFrame, ResourceBundle resourceBundle) {
        String message = resourceBundle.getString("dialog.change_laf.ok");
        String title = resourceBundle.getString("dialog.change_laf.title");
        ImageIcon icon = new ImageIcon(this.getClass().getResource(resourceBundle.getString("dialog.change_laf.icon")));
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(message);
        optionPane.setOptionType(1);
        optionPane.setIcon(icon);
        DialogFactory.getInstance().showDialog(optionPane, title, true);
        int result = 2;
        if (!JOptionPane.UNINITIALIZED_VALUE.equals(optionPane.getValue())) {
            result = (Integer)optionPane.getValue();
        }
        if (result == 0) {
            ThemeManager.getInstance().setPreferedLookAndFeel(className);
            editorFrame.restart();
        }
        if (result == 1) {
            ThemeManager.getInstance().setPreferedLookAndFeel(className);
        }
    }
}

