/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.util.UniqueIDGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.UIManager;

public abstract class AbstractNode
implements Node {
    private static final Color SHADOW_COLOR = Color.LIGHT_GRAY;
    protected static Color BACKGROUND_COLOR = UIManager.getColor("TextPane.background");
    public static final int SHADOW_GAP = 4;
    private ArrayList<Node> children;
    private Node parent = null;
    private Graph graph;
    private Point2D.Double location;
    private transient int z;
    protected String id;
    protected Integer revision = new Integer(0);

    public AbstractNode() {
        this.children = new ArrayList();
        this.id = UniqueIDGenerator.getNewId();
    }

    @Override
    public Point2D getLocation() {
        if (this.location == null) {
            return new Point2D.Double(this.getBounds().getX(), this.getBounds().getY());
        }
        return this.location;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void changeId() {
        this.id = UniqueIDGenerator.getNewId();
    }

    @Override
    public Integer getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(Integer newRevisionNumber) {
        this.revision = newRevisionNumber;
    }

    @Override
    public void incrementRevision() {
        int i = this.revision;
        this.revision = new Integer(++i);
    }

    @Override
    public void translate(double dx, double dy) {
        if (this.location == null) {
            this.location = (Point2D.Double)this.getLocation();
        }
        this.location.x += dx;
        this.location.y += dy;
        if (this.graph != null) {
            this.graph.fireNodeMoved(this, dx, dy);
        }
    }

    @Override
    public boolean checkAddEdge(Edge e, Point2D p1, Point2D p2) {
        return e.getEnd() != null;
    }

    @Override
    public void checkRemoveEdge(Edge e) {
    }

    @Override
    public void checkRemoveNode(Node e) {
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
    }

    @Override
    public boolean checkAddNode(Node n, Point2D p) {
        return false;
    }

    public List<Node> getAncestors() {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            result.add(parent);
        }
        return result;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    @Override
    public List<Node> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(int index, Node node) {
        Node oldParent = node.getParent();
        if (oldParent != null) {
            oldParent.removeChild(node);
        }
        this.children.add(index, node);
        if (node instanceof AbstractNode) {
            ((AbstractNode)node).setParent(this);
        }
        if (this.graph != null) {
            this.graph.fireChildAttached(index, this, node);
        }
    }

    public void addChild(Node node) {
        this.addChild(this.children.size(), node);
    }

    @Override
    public void removeChild(Node node) {
        if (node.getParent() != this) {
            return;
        }
        int i = this.children.indexOf(node);
        if (i >= 0) {
            this.children.remove(i);
            if (node instanceof AbstractNode) {
                ((AbstractNode)node).setParent(null);
            }
            if (this.graph != null) {
                this.graph.fireChildDetached(i, this, node);
            }
        }
    }

    @Override
    public void draw(Graphics2D g2) {
        Shape shape = this.getShape();
        if (shape == null) {
            return;
        }
        Color oldColor = g2.getColor();
        g2.translate(4, 4);
        g2.setColor(SHADOW_COLOR);
        g2.fill(shape);
        g2.translate(-4, -4);
        g2.setColor(BACKGROUND_COLOR);
        g2.fill(shape);
        g2.setColor(oldColor);
    }

    public Shape getShape() {
        return null;
    }

    @Override
    public boolean checkPasteChildren(Collection<Node> children) {
        return false;
    }

    public static void setPersistenceDelegate(Encoder encoder) {
        encoder.setPersistenceDelegate(AbstractNode.class, new DefaultPersistenceDelegate(){

            @Override
            protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
                super.initialize(type, oldInstance, newInstance, out);
                Node n = (Node)oldInstance;
                List<Node> children = n.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    Node c = children.get(i);
                    out.writeStatement(new Statement(oldInstance, "addChild", new Object[]{c}));
                }
            }
        });
    }

    @Override
    public AbstractNode clone() {
        try {
            AbstractNode cloned = (AbstractNode)super.clone();
            cloned.id = UniqueIDGenerator.getNewId();
            cloned.children = new ArrayList();
            cloned.location = (Point2D.Double)this.getLocation().clone();
            cloned.graph = null;
            return cloned;
        }
        catch (CloneNotSupportedException exception) {
            return null;
        }
    }

    @Override
    public void setGraph(Graph g) {
        this.graph = g;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public void setZ(int z) {
        this.z = z;
    }
}

