/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.util.SerializableEnumeration;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class BentStyle
extends SerializableEnumeration {
    private static final int MIN_SEGMENT = 10;
    private static final int SELF_WIDTH = 30;
    private static final int SELF_HEIGHT = 25;
    public static final BentStyle STRAIGHT = new BentStyle();
    public static final BentStyle HV = new BentStyle();
    public static final BentStyle VH = new BentStyle();
    public static final BentStyle HVH = new BentStyle();
    public static final BentStyle VHV = new BentStyle();

    private BentStyle() {
    }

    private Point2D[] connectionPoints(Rectangle2D r) {
        Point2D[] a = new Point2D[]{new Point2D.Double(r.getX(), r.getCenterY()), new Point2D.Double(r.getMaxX(), r.getCenterY()), new Point2D.Double(r.getCenterX(), r.getY()), new Point2D.Double(r.getCenterX(), r.getMaxY())};
        return a;
    }

    public ArrayList<Point2D> getPath(Rectangle2D startingRectangle, Rectangle2D endingRectangle) {
        ArrayList<Point2D> r = null;
        if (this == STRAIGHT) {
            r = this.getStraightPath(startingRectangle, endingRectangle);
        } else if (this == HV) {
            r = this.getHVPath(startingRectangle, endingRectangle);
        } else if (this == VH) {
            r = this.getVHPath(startingRectangle, endingRectangle);
        } else if (this == HVH) {
            r = this.getHVHPath(startingRectangle, endingRectangle);
        } else if (this == VHV) {
            r = this.getVHVPath(startingRectangle, endingRectangle);
        }
        if (r != null) {
            return r;
        }
        if (startingRectangle.equals(endingRectangle)) {
            r = this.getSelfPath(startingRectangle);
        } else if (this == HVH) {
            r = this.getVHVPath(startingRectangle, endingRectangle);
        } else if (this == VHV) {
            r = this.getHVHPath(startingRectangle, endingRectangle);
        } else if (this == HV) {
            r = this.getVHPath(startingRectangle, endingRectangle);
        } else if (this == VH) {
            r = this.getHVPath(startingRectangle, endingRectangle);
        }
        if (r != null) {
            return r;
        }
        return this.getStraightPath(startingRectangle, endingRectangle);
    }

    private ArrayList<Point2D> getVHVPath(Rectangle2D startingRectangle, Rectangle2D endingRectangle) {
        double y2;
        double y1;
        ArrayList<Point2D> r = new ArrayList<Point2D>();
        double x1 = startingRectangle.getCenterX();
        double x2 = endingRectangle.getCenterX();
        if (startingRectangle.getMaxY() + 20.0 <= endingRectangle.getY()) {
            y1 = startingRectangle.getMaxY();
            y2 = endingRectangle.getY();
        } else if (endingRectangle.getMaxY() + 20.0 <= startingRectangle.getY()) {
            y1 = startingRectangle.getY();
            y2 = endingRectangle.getMaxY();
        } else {
            return null;
        }
        if (Math.abs(x1 - x2) <= 10.0) {
            r.add(new Point2D.Double(x2, y1));
            r.add(new Point2D.Double(x2, y2));
        } else {
            r.add(new Point2D.Double(x1, y1));
            r.add(new Point2D.Double(x1, (y1 + y2) / 2.0));
            r.add(new Point2D.Double(x2, (y1 + y2) / 2.0));
            r.add(new Point2D.Double(x2, y2));
        }
        return r;
    }

    private ArrayList<Point2D> getHVHPath(Rectangle2D startingRectangle, Rectangle2D endingRectangle) {
        double x2;
        double x1;
        ArrayList<Point2D> r = new ArrayList<Point2D>();
        double y1 = startingRectangle.getCenterY();
        double y2 = endingRectangle.getCenterY();
        if (startingRectangle.getMaxX() + 20.0 <= endingRectangle.getX()) {
            x1 = startingRectangle.getMaxX();
            x2 = endingRectangle.getX();
        } else if (endingRectangle.getMaxX() + 20.0 <= startingRectangle.getX()) {
            x1 = startingRectangle.getX();
            x2 = endingRectangle.getMaxX();
        } else {
            return null;
        }
        if (Math.abs(y1 - y2) <= 10.0) {
            r.add(new Point2D.Double(x1, y2));
            r.add(new Point2D.Double(x2, y2));
        } else {
            r.add(new Point2D.Double(x1, y1));
            r.add(new Point2D.Double((x1 + x2) / 2.0, y1));
            r.add(new Point2D.Double((x1 + x2) / 2.0, y2));
            r.add(new Point2D.Double(x2, y2));
        }
        return r;
    }

    private ArrayList<Point2D> getVHPath(Rectangle2D startingRectangle, Rectangle2D endingRectangle) {
        double y1;
        double x2;
        ArrayList<Point2D> r = new ArrayList<Point2D>();
        double x1 = startingRectangle.getCenterX();
        double y2 = endingRectangle.getCenterY();
        if (x1 + 10.0 <= endingRectangle.getX()) {
            x2 = endingRectangle.getX();
        } else if (x1 - 10.0 >= endingRectangle.getMaxX()) {
            x2 = endingRectangle.getMaxX();
        } else {
            return null;
        }
        if (y2 + 10.0 <= startingRectangle.getY()) {
            y1 = startingRectangle.getY();
        } else if (y2 - 10.0 >= startingRectangle.getMaxY()) {
            y1 = startingRectangle.getMaxY();
        } else {
            return null;
        }
        r.add(new Point2D.Double(x1, y1));
        r.add(new Point2D.Double(x1, y2));
        r.add(new Point2D.Double(x2, y2));
        return r;
    }

    private ArrayList<Point2D> getHVPath(Rectangle2D startingRectangle, Rectangle2D endingRectangle) {
        double y2;
        double x1;
        ArrayList<Point2D> r = new ArrayList<Point2D>();
        double x2 = endingRectangle.getCenterX();
        double y1 = startingRectangle.getCenterY();
        if (x2 + 10.0 <= startingRectangle.getX()) {
            x1 = startingRectangle.getX();
        } else if (x2 - 10.0 >= startingRectangle.getMaxX()) {
            x1 = startingRectangle.getMaxX();
        } else {
            return null;
        }
        if (y1 + 10.0 <= endingRectangle.getY()) {
            y2 = endingRectangle.getY();
        } else if (y1 - 10.0 >= endingRectangle.getMaxY()) {
            y2 = endingRectangle.getMaxY();
        } else {
            return null;
        }
        r.add(new Point2D.Double(x1, y1));
        r.add(new Point2D.Double(x2, y1));
        r.add(new Point2D.Double(x2, y2));
        return r;
    }

    private ArrayList<Point2D> getStraightPath(Rectangle2D startingRectangle, Rectangle2D endingRectangle) {
        Point2D[] b;
        Point2D q;
        ArrayList<Point2D> r = new ArrayList<Point2D>();
        Point2D[] a = this.connectionPoints(startingRectangle);
        Point2D p = a[0];
        double distance = p.distance(q = (b = this.connectionPoints(endingRectangle))[0]);
        if (distance == 0.0) {
            return null;
        }
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                double d = a[i].distance(b[j]);
                if (!(d < distance)) continue;
                p = a[i];
                q = b[j];
                distance = d;
            }
        }
        r.add(p);
        r.add(q);
        return r;
    }

    private ArrayList<Point2D> getSelfPath(Rectangle2D s) {
        ArrayList<Point2D> r = new ArrayList<Point2D>();
        double x1 = s.getX() + s.getWidth() * 3.0 / 4.0;
        double y1 = s.getY();
        double y2 = s.getY() - 25.0;
        double x2 = s.getX() + s.getWidth() + 30.0;
        double y3 = s.getY() + s.getHeight() / 4.0;
        double x3 = s.getX() + s.getWidth();
        r.add(new Point2D.Double(x1, y1));
        r.add(new Point2D.Double(x1, y2));
        r.add(new Point2D.Double(x2, y2));
        r.add(new Point2D.Double(x2, y3));
        r.add(new Point2D.Double(x3, y3));
        return r;
    }
}

