/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import com.horstmann.violet.framework.gui.EditorFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class SplashScreen
extends JWindow {
    public SplashScreen() {
        this.prepare();
    }

    public SplashScreen(EditorFrame editorFrame) {
        super(editorFrame);
        this.prepare();
    }

    private void prepare() {
        ResourceBundle bundle = ResourceBundle.getBundle("properties.AboutStrings", Locale.getDefault());
        String imagePath = bundle.getString("dialog.about.image");
        JLabel l = new JLabel(new ImageIcon(this.getClass().getResource(imagePath)));
        this.getContentPane().add((Component)l, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = l.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
    }

    public static void displayOverEditor(EditorFrame editorFrame, int waitTime) {
        final SplashScreen splashScreen = new SplashScreen(editorFrame);
        splashScreen.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                splashScreen.setVisible(false);
                splashScreen.dispose();
            }
        });
        final int pause = waitTime;
        final Runnable closerRunner = new Runnable(){

            @Override
            public void run() {
                splashScreen.setVisible(false);
                splashScreen.dispose();
            }
        };
        Runnable waitRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(pause);
                    SwingUtilities.invokeAndWait(closerRunner);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        splashScreen.setVisible(true);
        Thread splashThread = new Thread(waitRunner, "SplashThread");
        splashThread.start();
    }
}

