/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.menu;

import com.horstmann.violet.framework.action.FileAction;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.file.FileChooserService;
import com.horstmann.violet.framework.file.FileChooserServiceFactory;
import com.horstmann.violet.framework.file.FileService;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.EditorFrame;
import com.horstmann.violet.framework.resources.ResourceFactory;
import com.horstmann.violet.product.diagram.activity.ActivityDiagramGraph;
import com.horstmann.violet.product.diagram.classes.ClassDiagramGraph;
import com.horstmann.violet.product.diagram.object.ObjectDiagramGraph;
import com.horstmann.violet.product.diagram.sequence.SequenceDiagramGraph;
import com.horstmann.violet.product.diagram.state.StateDiagramGraph;
import com.horstmann.violet.product.diagram.usecase.UseCaseDiagramGraph;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class FileMenu
extends JMenu {
    private FileChooserService fileChooserService;
    private EditorFrame editorFrame;
    private List<String> recentFiles;
    private JMenu fileNewMenu;
    private JMenu fileRecentMenu;
    private ResourceFactory menuFactory;
    private FileAction fileAction = new FileAction();

    public FileMenu(EditorFrame editorFrame, ResourceFactory factory) {
        this.menuFactory = factory;
        this.editorFrame = editorFrame;
        this.fileChooserService = FileChooserServiceFactory.getInstance();
        this.recentFiles = FileService.getRecentFiles();
        this.createMenu();
    }

    private void createMenu() {
        this.menuFactory.configureMenu(this, "file");
        this.fileNewMenu = this.menuFactory.createMenu("file.new");
        this.createGraphTypeMenuItem("file.new.usecase_diagram", UseCaseDiagramGraph.class, this.menuFactory, this.editorFrame);
        this.createGraphTypeMenuItem("file.new.class_diagram", ClassDiagramGraph.class, this.menuFactory, this.editorFrame);
        this.createGraphTypeMenuItem("file.new.object_diagram", ObjectDiagramGraph.class, this.menuFactory, this.editorFrame);
        this.createGraphTypeMenuItem("file.new.state_diagram", StateDiagramGraph.class, this.menuFactory, this.editorFrame);
        this.createGraphTypeMenuItem("file.new.activity_diagram", ActivityDiagramGraph.class, this.menuFactory, this.editorFrame);
        this.createGraphTypeMenuItem("file.new.sequence_diagram", SequenceDiagramGraph.class, this.menuFactory, this.editorFrame);
        this.add(this.fileNewMenu);
        JMenuItem fileOpenItem = this.menuFactory.createMenuItem("file.open");
        fileOpenItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileMenu.this.performOpen();
            }
        });
        this.add(fileOpenItem);
        JMenuItem fileOpenRemoteItem = this.menuFactory.createMenuItem("file.open_remote");
        fileOpenRemoteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileMenu.this.performOpenRemote();
            }
        });
        this.add(fileOpenRemoteItem);
        JMenuItem fileCloseItem = this.menuFactory.createMenuItem("file.close");
        fileCloseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileMenu.this.performClose();
            }
        });
        this.add(fileCloseItem);
        this.fileRecentMenu = this.menuFactory.createMenu("file.recent");
        this.buildRecentFilesMenu();
        this.add(this.fileRecentMenu);
        JMenuItem fileSaveItem = this.menuFactory.createMenuItem("file.save");
        fileSaveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.performSave();
            }
        });
        this.add(fileSaveItem);
        JMenuItem fileSaveAsItem = this.menuFactory.createMenuItem("file.save_as");
        fileSaveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.performSaveAs();
            }
        });
        this.add(fileSaveAsItem);
        JMenuItem fileExportItem = this.menuFactory.createMenuItem("file.export_to_image");
        fileExportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.performExportToImage();
            }
        });
        JMenuItem fileExportToClipBoard = this.menuFactory.createMenuItem("file.export_to_clipboard");
        fileExportToClipBoard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.performExportToClipBoard();
            }
        });
        JMenuItem fileExportToXMI = this.menuFactory.createMenuItem("file.export_to_xmi");
        fileExportToXMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.performExportToXMI();
            }
        });
        JMenuItem fileExportToJava = this.menuFactory.createMenuItem("file.export_to_java");
        fileExportToJava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.performExportToJava();
            }
        });
        JMenuItem fileExportToPython = this.menuFactory.createMenuItem("file.export_to_python");
        fileExportToPython.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.performExportToPython();
            }
        });
        JMenu fileExportMenu = this.menuFactory.createMenu("file.export");
        fileExportMenu.add(fileExportItem);
        fileExportMenu.add(fileExportToClipBoard);
        this.add(fileExportMenu);
        JMenuItem filePrintItem = this.menuFactory.createMenuItem("file.print");
        filePrintItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.performPrint();
            }
        });
        this.add(filePrintItem);
        JMenuItem fileExitItem = this.menuFactory.createMenuItem("file.exit");
        fileExitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileMenu.this.performExit();
            }
        });
        this.add(fileExitItem);
        if (this.fileChooserService == null) {
            fileOpenItem.setEnabled(false);
            fileSaveAsItem.setEnabled(false);
            fileExportItem.setEnabled(false);
            fileExportToClipBoard.setEnabled(false);
            filePrintItem.setEnabled(false);
            fileExitItem.setEnabled(false);
        }
        if (this.fileChooserService == null || this.fileChooserService.isWebStart()) {
            this.fileRecentMenu.setEnabled(false);
            fileSaveItem.setEnabled(false);
        }
    }

    public void createGraphTypeMenuItem(String resourceName, final Class<? extends Graph> graphClass, ResourceFactory factory, EditorFrame editorFrame) {
        JMenuItem item = factory.createMenuItem(resourceName);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileMenu.this.performNew(graphClass);
            }
        });
        this.fileNewMenu.add(item);
    }

    public void addRecentFile(String newFile) {
        this.recentFiles.remove(newFile);
        if (newFile == null || newFile.equals("")) {
            return;
        }
        this.recentFiles.add(0, newFile);
        for (int i = 5; i < this.recentFiles.size(); ++i) {
            this.recentFiles.remove(i);
        }
        this.buildRecentFilesMenu();
    }

    public List<String> getRecentFiles() {
        return this.recentFiles;
    }

    public JMenu getFileNewMenu() {
        return this.fileNewMenu;
    }

    public JMenu getFileRecentMenu() {
        return this.fileRecentMenu;
    }

    private void buildRecentFilesMenu() {
        this.fileRecentMenu.removeAll();
        for (int i = 0; i < this.recentFiles.size(); ++i) {
            final String file = this.recentFiles.get(i);
            String name = new File(file).getName();
            JMenuItem item = new JMenuItem(name);
            this.fileRecentMenu.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    FileMenu.this.fileAction.open(file, FileMenu.this.editorFrame);
                }
            });
        }
    }

    private void performOpen() {
        this.fileAction.open(this, this.fileChooserService, this.editorFrame);
    }

    private void performOpenRemote() {
        this.fileAction.openRemoteFile(this, this.editorFrame);
    }

    private void performClose() {
        DiagramPanel diagramPanel = (DiagramPanel)this.editorFrame.getTabbedPane().getSelectedComponent();
        if (diagramPanel != null) {
            this.fileAction.close(this, this.editorFrame, diagramPanel, this.fileChooserService);
        }
    }

    private void performSave() {
        DiagramPanel diagramPanel = (DiagramPanel)this.editorFrame.getTabbedPane().getSelectedComponent();
        if (diagramPanel != null) {
            this.fileAction.save(this, diagramPanel, this.fileChooserService);
        }
    }

    private void performSaveAs() {
        DiagramPanel diagramPanel = (DiagramPanel)this.editorFrame.getTabbedPane().getSelectedComponent();
        if (diagramPanel != null) {
            this.fileAction.saveAs(this, diagramPanel, this.fileChooserService);
        }
    }

    private void performExportToImage() {
        DiagramPanel diagramPanel = (DiagramPanel)this.editorFrame.getTabbedPane().getSelectedComponent();
        if (diagramPanel != null) {
            this.fileAction.exportImage(diagramPanel, this.fileChooserService);
        }
    }

    private void performExportToClipBoard() {
        DiagramPanel diagramPanel = (DiagramPanel)this.editorFrame.getTabbedPane().getSelectedComponent();
        if (diagramPanel != null) {
            this.fileAction.exportToClipboard(diagramPanel);
        }
    }

    private void performExportToXMI() {
        DiagramPanel diagramPanel = (DiagramPanel)this.editorFrame.getTabbedPane().getSelectedComponent();
        if (diagramPanel != null) {
            this.fileAction.exportToXMI(diagramPanel, this.fileChooserService);
        }
    }

    private void performExportToJava() {
        DiagramPanel diagramPanel = (DiagramPanel)this.editorFrame.getTabbedPane().getSelectedComponent();
        if (diagramPanel != null) {
            // empty if block
        }
    }

    private void performExportToPython() {
        DiagramPanel diagramPanel = (DiagramPanel)this.editorFrame.getTabbedPane().getSelectedComponent();
        if (diagramPanel != null) {
            // empty if block
        }
    }

    private void performPrint() {
        DiagramPanel diagramPanel = (DiagramPanel)this.editorFrame.getTabbedPane().getSelectedComponent();
        if (diagramPanel != null) {
            this.fileAction.print(diagramPanel);
        }
    }

    private void performExit() {
        this.fileAction.exit(this, this.editorFrame, this.fileChooserService);
    }

    private void performNew(Class<? extends Graph> graphClass) {
        this.fileAction.createDiagram(graphClass, this.editorFrame);
    }
}

