/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Set;

public class StringFilterOutputStream
extends ByteArrayOutputStream {
    private Map<String, String> replaceMap;
    private OutputStream originalOutputStream;

    public StringFilterOutputStream(OutputStream out, Map<String, String> replaceMap) {
        this.replaceMap = replaceMap;
        this.originalOutputStream = out;
    }

    @Override
    public void close() throws IOException {
        String filteredContent = this.getFilteredContent(this.toString("UTF-8"), this.replaceMap);
        try {
            this.originalOutputStream.write(filteredContent.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            this.originalOutputStream.write(filteredContent.getBytes());
        }
        this.originalOutputStream.close();
        super.close();
    }

    private String getFilteredContent(String input, Map<String, String> replaceMap) {
        Set<String> set = replaceMap.keySet();
        for (String searchedStr : set) {
            String replaceStr = replaceMap.get(searchedStr);
            input = input.replaceAll(searchedStr, replaceStr);
        }
        return input;
    }
}

