/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.activity;

import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.framework.diagram.RectangularNode;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class ActivityNode
extends RectangularNode {
    private MultiLineString name = new MultiLineString();
    private static int ARC_SIZE = 20;
    private static int DEFAULT_WIDTH = 80;
    private static int DEFAULT_HEIGHT = 60;

    public ActivityNode() {
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        g2.draw(this.getShape());
        this.name.draw(g2, this.getBounds());
    }

    @Override
    public Shape getShape() {
        return new RoundRectangle2D.Double(this.getBounds().getX(), this.getBounds().getY(), this.getBounds().getWidth(), this.getBounds().getHeight(), ARC_SIZE, ARC_SIZE);
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        Rectangle2D b = this.name.getBounds(g2);
        this.snapBounds(grid, Math.max(b.getWidth(), (double)DEFAULT_WIDTH), Math.max(b.getHeight(), (double)DEFAULT_HEIGHT));
    }

    public void setName(MultiLineString newValue) {
        this.name = newValue;
    }

    public MultiLineString getName() {
        return this.name;
    }

    @Override
    public ActivityNode clone() {
        ActivityNode cloned = (ActivityNode)super.clone();
        cloned.name = this.name.clone();
        return cloned;
    }
}

