/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.common;

import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.ShapeEdge;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class NoteEdge
extends ShapeEdge {
    private static Stroke DOTTED_STROKE = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);

    @Override
    public void draw(Graphics2D g2) {
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(DOTTED_STROKE);
        g2.draw(this.getConnectionPoints());
        g2.setStroke(oldStroke);
    }

    @Override
    public Line2D getConnectionPoints() {
        Rectangle2D start = this.getStart().getBounds();
        Rectangle2D end = this.getEnd().getBounds();
        Direction d = new Direction(end.getCenterX() - start.getCenterX(), end.getCenterY() - start.getCenterY());
        return new Line2D.Double(this.getStart().getConnectionPoint(d), this.getEnd().getConnectionPoint(d.turn(180.0)));
    }

    @Override
    public Shape getShape() {
        GeneralPath path = new GeneralPath();
        Line2D conn = this.getConnectionPoints();
        path.moveTo((float)conn.getX1(), (float)conn.getY1());
        path.lineTo((float)conn.getX2(), (float)conn.getY2());
        return path;
    }
}

