/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.object;

import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.diagram.RectangularNode;
import com.horstmann.violet.product.diagram.common.PointNode;
import com.horstmann.violet.product.diagram.object.ObjectNode;
import com.horstmann.violet.product.diagram.object.ObjectReferenceEdge;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class FieldNode
extends RectangularNode {
    private transient double axisX;
    private MultiLineString name;
    private MultiLineString value;
    private MultiLineString equalSeparator;
    private transient Rectangle2D nameBounds;
    private transient Rectangle2D valueBounds;
    private transient Rectangle2D equalBounds;
    public static int DEFAULT_WIDTH = 60;
    public static int DEFAULT_HEIGHT = 20;

    public FieldNode() {
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
        this.name = new MultiLineString();
        this.name.setJustification(2);
        this.value = new MultiLineString();
        this.equalSeparator = new MultiLineString();
        this.equalSeparator.setText(" = ");
        this.setZ(1);
    }

    @Override
    public void draw(Graphics2D g2) {
        Rectangle2D b = this.getBounds();
        double leftWidth = this.name.getBounds(g2).getWidth();
        double middleWidth = this.equalSeparator.getBounds(g2).getWidth();
        double rightWidth = this.value.getBounds(g2).getWidth();
        this.nameBounds = new Rectangle2D.Double(b.getX(), b.getY(), leftWidth, b.getHeight());
        this.equalBounds = new Rectangle2D.Double(b.getX() + leftWidth, b.getY(), middleWidth, b.getHeight());
        this.valueBounds = new Rectangle2D.Double(b.getX() + leftWidth + middleWidth, b.getY(), rightWidth, b.getHeight());
        this.name.draw(g2, this.nameBounds);
        this.equalSeparator.draw(g2, this.equalBounds);
        this.value.draw(g2, this.valueBounds);
    }

    @Override
    public boolean checkAddEdge(Edge e, Point2D p1, Point2D p2) {
        Node endingNode = e.getEnd();
        if (e instanceof ObjectReferenceEdge && endingNode instanceof ObjectNode) {
            MultiLineString oldValue = this.value.clone();
            this.value.setText("");
            Graph g = this.getGraph();
            if (g != null) {
                g.firePropertyChange(this, "value", oldValue, this.value);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean checkAddNode(Node n, Point2D p) {
        return n instanceof PointNode;
    }

    @Override
    public Point2D getConnectionPoint(Direction d) {
        Rectangle2D b = this.getBounds();
        return new Point2D.Double((b.getMaxX() + b.getX() + this.axisX) / 2.0, b.getCenterY());
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        this.nameBounds = this.name.getBounds(g2);
        this.valueBounds = this.value.getBounds(g2);
        this.equalBounds = this.equalSeparator.getBounds(g2);
        double leftWidth = this.nameBounds.getWidth();
        double middleWidth = this.equalBounds.getWidth();
        double rightWidth = this.valueBounds.getWidth();
        double totalWidth = leftWidth + middleWidth + rightWidth;
        double leftHeight = this.nameBounds.getHeight();
        double middleHeight = this.equalBounds.getHeight();
        double rightHeight = this.valueBounds.getHeight();
        double globalHeight = Math.max(leftHeight, rightHeight);
        globalHeight = Math.max(middleHeight, globalHeight);
        if (this.getParent() == null) {
            this.snapBounds(grid, totalWidth, globalHeight);
        } else {
            this.setBounds(new Rectangle2D.Double(this.getLocation().getX(), this.getLocation().getY(), totalWidth, globalHeight));
        }
        this.axisX = leftWidth + middleWidth / 2.0;
    }

    public void setName(MultiLineString newValue) {
        this.name = newValue;
    }

    public MultiLineString getName() {
        return this.name;
    }

    public void setValue(MultiLineString newValue) {
        this.value = newValue;
    }

    public MultiLineString getValue() {
        return this.value;
    }

    public double getAxisX() {
        return this.axisX;
    }

    @Override
    public FieldNode clone() {
        FieldNode cloned = (FieldNode)super.clone();
        cloned.name = this.name.clone();
        cloned.value = this.value.clone();
        return cloned;
    }
}

