/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsUtils;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;

public class PgsComboBoxButtonUI
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly = false;

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean bl) {
        this.iconOnly = bl;
    }

    public PgsComboBoxButtonUI() {
        super("");
        DefaultButtonModel defaultButtonModel = new DefaultButtonModel(){

            public void setArmed(boolean bl) {
                super.setArmed(this.isPressed() ? true : bl);
            }
        };
        this.setModel(defaultButtonModel);
    }

    public PgsComboBoxButtonUI(JComboBox jComboBox, Icon icon, CellRendererPane cellRendererPane, JList jList) {
        this();
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.rendererPane = cellRendererPane;
        this.listBox = jList;
        this.setEnabled(this.comboBox.isEnabled());
    }

    public PgsComboBoxButtonUI(JComboBox jComboBox, Icon icon, boolean bl, CellRendererPane cellRendererPane, JList jList) {
        this(jComboBox, icon, cellRendererPane, jList);
        this.iconOnly = bl;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        boolean bl = PgsUtils.isLeftToRight(this.comboBox);
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        int n2 = this.getWidth() - (insets.left + insets.right);
        int n3 = this.getHeight() - (insets.top + insets.bottom);
        if (n3 <= 0 || n2 <= 0) {
            return;
        }
        int n4 = insets.left;
        int n5 = insets.top;
        int n6 = n4 + (n2 - 1);
        int n7 = n5 + (n3 - 1);
        int n8 = 0;
        int n9 = n = bl ? n6 : n4;
        if (this.comboIcon != null) {
            n8 = this.comboIcon.getIconWidth();
            int n10 = this.comboIcon.getIconHeight();
            int n11 = 0;
            if (this.iconOnly) {
                n = this.getWidth() / 2 - n8 / 2;
                n11 = this.getHeight() / 2 - n10 / 2;
            } else {
                n = bl ? this.getWidth() / 2 - n8 / 2 : n4;
                n11 = n5 + (n7 - n5) / 2 - n10 / 2;
            }
            this.comboIcon.paintIcon(this, graphics, n, n11);
        }
    }
}

