/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.pattern;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.ws.jaxme.js.DirectAccessible;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.apps.XmlRpcClientGenerator;
import org.apache.ws.jaxme.js.pattern.ChainGenerator;
import org.apache.ws.jaxme.js.pattern.CompiledClassReflector;
import org.apache.ws.jaxme.js.pattern.InterfaceDescription;
import org.apache.ws.jaxme.js.pattern.ProxyGenerator;
import org.apache.ws.jaxme.js.pattern.Reflector;
import org.apache.ws.jaxme.js.pattern.SourceReflector;
import org.apache.ws.jaxme.js.pattern.TypesafeEnumerationGenerator;
import org.apache.ws.jaxme.js.pattern.VersionGenerator;
import org.apache.ws.jaxme.logging.AntProjectLoggerFactory;
import org.apache.ws.jaxme.logging.LoggerAccess;
import org.apache.ws.jaxme.logging.LoggerFactory;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.Index;
import org.apache.ws.jaxme.sqls.Schema;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.impl.ColumnImpl;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;

public class Ant {
    protected static JavaQName getJavaQName(String pName) {
        return JavaQNameImpl.getInstance(pName);
    }

    public static class XmlRpcGenerator
    extends ReallyBasicAntTask {
        private final List serverClasses = new ArrayList();
        private final JavaSourceFactory jsf = new JavaSourceFactory();
        private String targetPackage;
        private Dispatcher dispatcher;

        public Dispatcher createDispatcher() {
            if (this.dispatcher != null) {
                throw new BuildException("The nested 'dispatcher' element must not be used more than once.");
            }
            this.dispatcher = new Dispatcher();
            return this.dispatcher;
        }

        public Dispatcher getDispatcher() {
            return this.dispatcher;
        }

        public void setTargetPackage(String pPackage) {
            this.targetPackage = pPackage;
        }

        public String getTargetPackage() {
            return this.targetPackage;
        }

        public FileSet createServerClasses() {
            FileSet fs = (FileSet)this.getProject().createDataType("fileset");
            this.serverClasses.add(fs);
            return fs;
        }

        public void finish() {
            super.finish();
            if (this.targetPackage == null) {
                throw new BuildException("Missing 'targetPackage' attribute", this.getLocation());
            }
            if (this.serverClasses.size() == 0) {
                throw new BuildException("Missing nested element 'serverClasses'", this.getLocation());
            }
        }

        public void doExecute() throws Exception {
            int i;
            JavaSourceFactory jsf = new JavaSourceFactory();
            JavaSourceFactory inputs = new JavaSourceFactory();
            XmlRpcClientGenerator gen = new XmlRpcClientGenerator(jsf, this.getTargetPackage());
            ArrayList<JavaSource> sources = new ArrayList<JavaSource>();
            for (i = 0; i < this.serverClasses.size(); ++i) {
                FileSet fs = (FileSet)this.serverClasses.get(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] files = ds.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    Reflector r;
                    String s = files[j];
                    if (s.endsWith(".class")) {
                        s = s.substring(0, s.length() - ".class".length());
                        r = new CompiledClassReflector(s.replace('/', '.'), Thread.currentThread().getContextClassLoader());
                    } else if (s.endsWith(".java")) {
                        r = new SourceReflector(new File(ds.getBasedir(), s));
                    } else {
                        throw new BuildException("Unknown extension in file name: " + s + ", expected .class or .java", this.getLocation());
                    }
                    JavaSource js = r.getJavaSource(inputs);
                    sources.add(js);
                }
            }
            for (i = 0; i < sources.size(); ++i) {
                JavaSource js = (JavaSource)sources.get(i);
                if (js.isAbstract()) {
                    this.getProject().log("Ignoring abstract class " + js.getQName(), 3);
                    continue;
                }
                this.getProject().log("Generating XML-RPC client for " + js.getQName(), 4);
                gen.addClass(js, inputs);
            }
            Dispatcher disp = this.getDispatcher();
            if (disp != null) {
                gen.setDispatcherImplementsXmlRpcHandler(disp.isImplementingXmlRpcHandler());
                gen.getDispatcher(JavaQNameImpl.getInstance(disp.getName()));
            }
            jsf.write(this.getDestDir());
        }

        public static class Dispatcher {
            private String name;
            private boolean implementingXmlRpcHandler = true;

            public void setName(String pName) {
                this.name = pName;
            }

            public String getName() {
                return this.name;
            }

            public boolean isImplementingXmlRpcHandler() {
                return this.implementingXmlRpcHandler;
            }

            public void setImplementingXmlRpcHandler(boolean pImplementingXmlRpcHandler) {
                this.implementingXmlRpcHandler = pImplementingXmlRpcHandler;
            }
        }
    }

    public static class AntVersionGenerator
    extends BasicAntTask {
        private String driver;
        private String url;
        private String user;
        private String password;
        private String schema;
        private String verColumn;
        private List tables;
        private boolean isGeneratingLogging;

        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String pDriver) {
            this.driver = pDriver;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String pPassword) {
            this.password = pPassword;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String pUrl) {
            this.url = pUrl;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String pUser) {
            this.user = pUser;
        }

        public String getSchema() {
            return this.schema;
        }

        public void setSchema(String pSchema) {
            this.schema = pSchema;
        }

        public void setTables(String pTables) {
            this.tables = new ArrayList();
            StringTokenizer st = new StringTokenizer(pTables);
            while (st.hasMoreTokens()) {
                String tableName = st.nextToken();
                this.tables.add(tableName);
            }
        }

        public List getTables() {
            return this.tables;
        }

        public void setVerColumn(String pColumn) {
            this.verColumn = pColumn;
        }

        public String getVerColumn() {
            return this.verColumn;
        }

        public void setGeneratingLogging(boolean pGeneratingLogging) {
            this.isGeneratingLogging = pGeneratingLogging;
        }

        public boolean isGeneratingLogging() {
            return this.isGeneratingLogging;
        }

        protected Connection getConnection() throws ClassNotFoundException, SQLException {
            String myUrl = this.getUrl();
            if (myUrl == null) {
                throw new NullPointerException("Missing 'url' attribute");
            }
            String myDriver = this.getDriver();
            if (myDriver != null) {
                try {
                    Class.forName(myDriver);
                }
                catch (ClassNotFoundException ex) {
                    try {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        if (cl == null) {
                            throw new ClassNotFoundException(myDriver);
                        }
                        cl.loadClass(myDriver);
                    }
                    catch (ClassNotFoundException ex2) {
                        throw ex;
                    }
                }
            }
            return DriverManager.getConnection(myUrl, this.getUser(), this.getPassword());
        }

        public void generate(JavaSourceFactory pFactory, JavaQName pTargetClass) throws Exception {
            List myTables = this.getTables();
            if (myTables == null) {
                throw new NullPointerException("Missing 'tables' attribute");
            }
            if (this.getVerColumn() == null) {
                throw new NullPointerException("Missing 'verColumn' attribute");
            }
            ColumnImpl.NameImpl columnName = new ColumnImpl.NameImpl(this.getVerColumn());
            SQLFactoryImpl factory = new SQLFactoryImpl();
            Schema sch = factory.getSchema(this.getConnection(), this.getSchema());
            VersionGenerator versionGenerator = new VersionGenerator();
            versionGenerator.setGeneratingLogging(this.isGeneratingLogging());
            boolean isFirstTable = true;
            Iterator iter = myTables.iterator();
            while (iter.hasNext()) {
                VersionGenerator.ColumnUpdater columnUpdater;
                String tableName = (String)iter.next();
                Table table = sch.getTable(tableName);
                if (table == null) {
                    throw new IllegalArgumentException("Invalid table name: " + tableName);
                }
                if (isFirstTable) {
                    Column column = null;
                    int columnNum = -1;
                    int i = 0;
                    Iterator colIter = table.getColumns();
                    while (colIter.hasNext()) {
                        Column colIterColumn = (Column)colIter.next();
                        if (colIterColumn.getName().equals(columnName)) {
                            column = colIterColumn;
                            columnNum = i;
                            break;
                        }
                        ++i;
                    }
                    if (column == null) {
                        throw new IllegalArgumentException("No column " + columnName + " found in table " + table.getQName());
                    }
                    isFirstTable = false;
                    columnUpdater = new VerNumIncrementer(columnNum);
                } else {
                    ArrayList<Integer> pkColumns = new ArrayList<Integer>();
                    Index primaryKey = table.getPrimaryKey();
                    if (primaryKey != null) {
                        Iterator pkIter = primaryKey.getColumns();
                        while (pkIter.hasNext()) {
                            Column pkColumn = (Column)pkIter.next();
                            int columnNum = -1;
                            int i = 0;
                            Iterator colIter = table.getColumns();
                            while (colIter.hasNext()) {
                                Column colIterColumn = (Column)colIter.next();
                                if (colIterColumn.getName().equals(pkColumn.getName())) {
                                    columnNum = i;
                                    break;
                                }
                                ++i;
                            }
                            if (columnNum == -1) {
                                throw new IllegalStateException("Primary key column " + pkColumn.getQName() + " not found in table " + table.getQName());
                            }
                            pkColumns.add(new Integer(columnNum));
                        }
                    }
                    if (pkColumns.size() == 0) {
                        throw new IllegalArgumentException("The table " + table.getQName() + " doesn't have a primary key.");
                    }
                    columnUpdater = new IdIncrementer(pkColumns);
                }
                versionGenerator.addTable(table, columnUpdater);
            }
            JavaSource js = pFactory.newJavaSource(pTargetClass);
            versionGenerator.getCloneMethod(js);
        }

        private class VerNumIncrementer
        implements VersionGenerator.ColumnUpdater {
            private final int columnNumber;

            VerNumIncrementer(int pColumnNumber) {
                this.columnNumber = pColumnNumber;
            }

            public void update(JavaMethod pMethod, VersionGenerator.TableInfo pTableInfo, DirectAccessible pConnection, DirectAccessible pMap, DirectAccessible pRow) {
                pMethod.addLine(pRow, "[" + this.columnNumber + "] = new Integer(((Integer) ", pRow, "[" + this.columnNumber + "]).intValue()+1);");
            }
        }

        private class IdIncrementer
        implements VersionGenerator.ColumnUpdater {
            private final List columns;

            IdIncrementer(List pColumns) {
                this.columns = pColumns;
            }

            public void update(JavaMethod pMethod, VersionGenerator.TableInfo pTableInfo, DirectAccessible pConnection, DirectAccessible pMap, DirectAccessible pRow) {
                Iterator iter = this.columns.iterator();
                while (iter.hasNext()) {
                    Integer columnNum = (Integer)iter.next();
                    pMethod.addLine(pRow, "[", columnNum, "] = Long.toString(Long.parseLong((String) ", pRow, "[", columnNum, "])+1);");
                }
            }
        }
    }

    public static class AntChainGenerator
    extends ReallyBasicAntTask {
        private List chains = new ArrayList();

        public ChainGenerator createChain() {
            ChainGenerator chain = new ChainGenerator();
            this.chains.add(chain);
            return chain;
        }

        public void finish() {
            if (this.chains.size() == 0) {
                throw new BuildException("At least one nested 'chain' element must be given.", this.getLocation());
            }
        }

        public void doExecute() {
            JavaSourceFactory pFactory = new JavaSourceFactory();
            Iterator iter = this.chains.iterator();
            while (iter.hasNext()) {
                ChainGenerator chain = (ChainGenerator)iter.next();
                try {
                    chain.generate(pFactory);
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e, this.getLocation());
                }
            }
            try {
                pFactory.write(this.getDestDir());
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e, this.getLocation());
            }
        }
    }

    public static class AntTypesafeEnumerationGenerator
    extends BasicAntTask {
        private List items = new ArrayList();
        private boolean isAddingEquals = true;

        public void setAddingEquals(boolean pAddingEquals) {
            this.isAddingEquals = pAddingEquals;
        }

        public TypesafeEnumerationGenerator.Item createItem() {
            TypesafeEnumerationGenerator.Item item = new TypesafeEnumerationGenerator.Item();
            this.items.add(item);
            return item;
        }

        public void finish() {
            super.finish();
            if (this.items.size() == 0) {
                throw new BuildException("The generated enumeration must have at least a single item.");
            }
        }

        public void generate(JavaSourceFactory pFactory, JavaQName pTargetClass) throws Exception {
            TypesafeEnumerationGenerator generator = new TypesafeEnumerationGenerator();
            generator.setAddingEquals(this.isAddingEquals);
            TypesafeEnumerationGenerator.Item[] myItems = this.items.toArray(new TypesafeEnumerationGenerator.Item[this.items.size()]);
            generator.generate(pFactory, pTargetClass, myItems);
        }
    }

    public static class AntProxyGenerator
    extends BasicAntTask {
        private JavaQName extendedClass;
        private List implementedInterfaces = new ArrayList();

        public void setExtendedClass(String pTargetClass) {
            this.extendedClass = Ant.getJavaQName(pTargetClass);
        }

        public InterfaceDescription createImplementedInterface() {
            InterfaceDescription result = new InterfaceDescription();
            this.implementedInterfaces.add(result);
            return result;
        }

        public void finish() {
            super.finish();
            if (this.implementedInterfaces.size() == 0) {
                throw new BuildException("You must specify at least one interface being implemented (child element 'implementedInterface')");
            }
        }

        public void generate(JavaSourceFactory pFactory, JavaQName pTargetClass) throws BuildException {
            ProxyGenerator proxyGenerator = new ProxyGenerator();
            if (this.extendedClass != null) {
                proxyGenerator.setExtendedClass(this.extendedClass);
            }
            try {
                proxyGenerator.generate(pFactory, pTargetClass, this.implementedInterfaces.toArray(new InterfaceDescription[this.implementedInterfaces.size()]));
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e, this.getLocation());
            }
        }
    }

    protected static abstract class BasicAntTask
    extends ReallyBasicAntTask {
        private JavaQName targetClass;

        protected BasicAntTask() {
        }

        public void setTargetClass(String pTargetClass) {
            this.targetClass = Ant.getJavaQName(pTargetClass);
        }

        public void finish() {
            if (this.targetClass == null) {
                throw new BuildException("The attribute 'targetClass' must be set.");
            }
        }

        public abstract void generate(JavaSourceFactory var1, JavaQName var2) throws Exception;

        public void doExecute() {
            this.finish();
            try {
                JavaSourceFactory factory = new JavaSourceFactory();
                this.generate(factory, this.targetClass);
                factory.write(this.getDestDir());
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e, this.getLocation());
            }
        }
    }

    protected static abstract class ReallyBasicAntTask
    extends Task {
        private File destDir;
        private boolean settingLoggerFactory = true;
        private String classpathRef;
        private Path classpath;

        protected ReallyBasicAntTask() {
        }

        public void setSettingLoggerFactory(boolean pSettingLoggerFactory) {
            this.settingLoggerFactory = pSettingLoggerFactory;
        }

        public boolean isSettingLoggerFactory() {
            return this.settingLoggerFactory;
        }

        public void setDestDir(File pDir) {
            this.destDir = pDir;
        }

        public File getDestDir() {
            return this.destDir;
        }

        public void setClasspathRef(String pRef) {
            if (this.classpath != null) {
                throw new BuildException("The 'classpathRef' attribute and the nested 'classpath' element are mutually exclusive.", this.getLocation());
            }
            this.classpathRef = pRef;
        }

        public String getClasspathRef() {
            return this.classpathRef;
        }

        public void addClasspath(Path pClasspath) {
            if (this.classpath != null) {
                throw new BuildException("Multiple nested 'classpath' elements are forbidden.", this.getLocation());
            }
            if (this.classpathRef != null) {
                throw new BuildException("The 'classpathRef' attribute and the nested 'classpath' element are mutually exclusive.", this.getLocation());
            }
            this.classpath = pClasspath;
        }

        public Path getClasspath() {
            return this.classpath;
        }

        public void finish() {
        }

        public abstract void doExecute() throws Exception;

        public void execute() {
            AntClassLoader acl;
            String cRef;
            Path classPath;
            LoggerFactory loggerFactory;
            if (this.isSettingLoggerFactory() && !((loggerFactory = LoggerAccess.getLoggerFactory()) instanceof AntProjectLoggerFactory)) {
                LoggerAccess.setLoggerFactory(new AntProjectLoggerFactory(this));
            }
            if ((classPath = this.getClasspath()) == null && (cRef = this.getClasspathRef()) != null && (classPath = (Path)this.getProject().getReference(cRef)) == null) {
                throw new BuildException("The reference " + cRef + " is not set.", this.getLocation());
            }
            if (classPath == null) {
                acl = null;
            } else {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null && (cl = ((Object)((Object)this)).getClass().getClassLoader()) == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                acl = new AntClassLoader(cl, this.getProject(), classPath, true);
                acl.setThreadContextLoader();
            }
            try {
                this.finish();
                this.doExecute();
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e, this.getLocation());
            }
            finally {
                if (acl != null) {
                    acl.resetThreadContextLoader();
                }
            }
        }
    }
}

