/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.apache.ws.jaxme.logging.Logger;
import org.apache.ws.jaxme.logging.LoggerAccess;

public class LinkChecker {
    Logger logger = LoggerAccess.getLogger(class$org$apache$ws$jaxme$js$util$LinkChecker == null ? (class$org$apache$ws$jaxme$js$util$LinkChecker = LinkChecker.class$("org.apache.ws.jaxme.js.util.LinkChecker")) : class$org$apache$ws$jaxme$js$util$LinkChecker);
    private Map urls = new HashMap();
    private Map checkedUrls = new HashMap();
    private int severity = 2;
    private String proxyHost;
    private String proxyPort;
    private boolean haveErrors;
    static /* synthetic */ Class class$org$apache$ws$jaxme$js$util$LinkChecker;

    protected void addEvent(Event pEvent) {
        String mName = "addEvent";
        this.logger.entering("addEvent", pEvent.toString());
        if (pEvent.mySeverity >= 2) {
            this.haveErrors = true;
        }
        if (pEvent.mySeverity >= this.getSeverity()) {
            System.err.println(pEvent.toString());
        }
        this.logger.exiting("addEvent");
    }

    protected void handleError(URL pURL, int pPos, String pMsg) {
        this.addEvent(new Event(2, pURL, pPos, pMsg));
    }

    protected void handleRefError(URL pURL, URL pRefURL, int pPos, String pMsg) {
        if (pRefURL == null) {
            this.handleError(pURL, pPos, pMsg);
        }
        this.addEvent(new RefEvent(2, pURL, pRefURL, pPos, pMsg));
    }

    protected void handleWarning(URL pURL, int pPos, String pMsg) {
        this.addEvent(new Event(1, pURL, pPos, pMsg));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger pLogger) {
        this.logger = pLogger;
    }

    public void setSeverity(String pSeverity) {
        if (pSeverity.equalsIgnoreCase("success")) {
            this.severity = 0;
        } else if (pSeverity.equalsIgnoreCase("warning")) {
            this.severity = 1;
        } else if (pSeverity.equalsIgnoreCase("error")) {
            this.severity = 2;
        } else {
            throw new IllegalArgumentException("Invalid severity, neither of success|warning|error: " + pSeverity);
        }
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setProxy(String pProxy) {
        if (pProxy == null && "".equals(pProxy)) {
            this.setProxyHost(null);
            this.setProxyPort(null);
        } else {
            int offset = pProxy.indexOf(58);
            if (offset == -1) {
                this.setProxyHost(pProxy);
                this.setProxyPort(null);
            } else {
                this.setProxyHost(pProxy.substring(0, offset));
                this.setProxyPort(pProxy.substring(offset + 1));
            }
        }
    }

    public void setProxyHost(String pHost) {
        if (pHost != null && "".equals(pHost)) {
            pHost = null;
        }
        this.proxyHost = pHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String pPort) {
        if (pPort != null && "".equals(pPort)) {
            pPort = null;
        }
        this.proxyPort = pPort;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void addURL(URL pURL, InputStream pStream) {
        CheckedURL url = new CheckedURL(pURL, null, -1);
        url.stream = pStream;
        this.addURL(url);
    }

    public void addURL(URL pURL) {
        this.addURL(new CheckedURL(pURL, null, -1));
    }

    public void addURL(CheckedURL pURL) {
        String mName = "addURL(URL)";
        this.logger.finest("addURL(URL)", "->", new Object[]{pURL.url, pURL.referencingURL, Integer.toString(pURL.referencingPos)});
        if (this.urls.containsKey(pURL.url) || this.checkedUrls.containsKey(pURL.url)) {
            this.logger.exiting("addURL(URL)", "Already registered");
            return;
        }
        this.urls.put(pURL.url, pURL);
        this.logger.finest("addURL(URL)", "<-", "New URL");
    }

    public void parse(CheckedURL pURL) throws IOException {
        String mName = "parse(CheckedURL)";
        this.logger.finest("parse(CheckedURL)", "->", pURL.url);
        this.logger.fine("parse(CheckedURL)", "Open", pURL.url);
        InputStream stream = pURL.stream;
        if (stream == null) {
            try {
                stream = pURL.url.openStream();
            }
            catch (IOException e) {
                this.handleRefError(pURL.url, pURL.referencingURL, pURL.referencingPos, "Failed to open URL: " + e.getMessage());
                return;
            }
        }
        if (pURL.checkExistsOnly || pURL.isExtern) {
            stream.close();
        } else {
            BufferedInputStream bStream = new BufferedInputStream(stream, 4096);
            ParserDelegator parser = new ParserDelegator();
            URLChecker callback = new URLChecker(pURL);
            parser.parse(new InputStreamReader(bStream), callback, false);
            bStream.close();
        }
        this.logger.finest("parse(CheckedURL)", "<-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        CheckedURL checkedURL;
        Iterator iter;
        String mName = "parse";
        this.logger.finest("parse", "->");
        this.haveErrors = false;
        boolean isProxySetSet = System.getProperties().contains("http.proxySet");
        String proxySet = System.getProperty("http.proxySet");
        boolean isProxyHostSet = System.getProperties().contains("http.proxyHost");
        String myProxyHost = System.getProperty("http.proxyHost");
        boolean isProxyPortSet = System.getProperties().contains("http.proxyPort");
        String myProxyPort = System.getProperty("http.proxyPort");
        String host = this.getProxyHost();
        if (host != null) {
            System.setProperty("http.proxySet", "true");
            System.setProperty("http.proxyHost", host);
            String port = this.getProxyPort();
            if (port != null) {
                System.setProperty("http.proxyPort", port);
            }
        }
        try {
            while (!this.urls.isEmpty()) {
                iter = this.urls.values().iterator();
                checkedURL = (CheckedURL)iter.next();
                try {
                    this.parse(checkedURL);
                }
                catch (IOException e) {}
                continue;
                finally {
                    this.urls.remove(checkedURL.url);
                    this.checkedUrls.put(checkedURL.url, checkedURL);
                }
            }
        }
        finally {
            if (host != null) {
                if (isProxySetSet) {
                    System.setProperty("http.proxySet", proxySet);
                } else {
                    System.getProperties().remove("http.proxySet");
                }
                if (isProxyHostSet) {
                    System.setProperty("http.proxyHost", myProxyHost);
                } else {
                    System.getProperties().remove("http.proxyHost");
                }
                if (isProxyPortSet) {
                    System.setProperty("http.proxyPort", myProxyPort);
                } else {
                    System.getProperties().remove("http.proxyPort");
                }
            }
        }
        iter = this.checkedUrls.values().iterator();
        while (iter.hasNext()) {
            checkedURL = (CheckedURL)iter.next();
            checkedURL.validate();
        }
        if (!this.haveErrors) {
            System.out.println("No errors found.");
        }
        this.logger.finest("parse", "<-");
    }

    public static void main(String[] args) {
        LinkChecker checker = new LinkChecker();
        for (int i = 0; i < args.length; ++i) {
            InputStream stream;
            URL url;
            try {
                url = new URL(args[i]);
                stream = url.openStream();
            }
            catch (IOException e) {
                try {
                    File f = new File(args[i]);
                    stream = new FileInputStream(f);
                    url = f.toURL();
                }
                catch (IOException f) {
                    System.err.println("Failed to open URL: " + args[i]);
                    continue;
                }
            }
            checker.addURL(url, stream);
            checker.parse();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class URLChecker
    extends HTMLEditorKit.ParserCallback {
        CheckedURL url;

        private URLChecker(CheckedURL pURL) {
            this.url = pURL;
        }

        protected void addLink(String pTagName, String pAttributeName, String pAttributeValue, int pPos, boolean pCheckExistsOnly) {
            String mName = "URLChecker.addLink";
            LinkChecker.this.logger.finest("URLChecker.addLink", "->", new Object[]{pTagName, pAttributeName, pAttributeValue, Integer.toString(pPos), pCheckExistsOnly ? Boolean.TRUE : Boolean.FALSE});
            LinkChecker.this.logger.finest("URLChecker.addLink", "My URL: " + this.url.url);
            URL myUrl = null;
            boolean isAbsolute = false;
            try {
                myUrl = new URL(pAttributeValue);
                isAbsolute = true;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (!isAbsolute) {
                try {
                    myUrl = new URL(this.url.url, pAttributeValue);
                }
                catch (MalformedURLException e) {
                    LinkChecker.this.handleError(this.url.url, pPos, "Failed to parse URL of attribute " + pAttributeName + " in tag " + pTagName);
                    return;
                }
            }
            if ("mailto".equals(myUrl.getProtocol())) {
                return;
            }
            CheckedURL checkedURL = new CheckedURL(myUrl, this.url.url, pPos);
            checkedURL.checkExistsOnly = pCheckExistsOnly;
            checkedURL.isExtern = isAbsolute;
            LinkChecker.this.addURL(checkedURL);
            LinkChecker.this.logger.finest("URLChecker.addLink", "<-");
        }

        protected void handleTag(HTML.Tag t, MutableAttributeSet a, int pPos) {
            String mName = "URLChecker.handleTag";
            LinkChecker.this.logger.finest("URLChecker.handleTag", "->", new Object[]{t, a, Integer.toString(pPos)});
            String tagName = t.toString().toLowerCase();
            Enumeration<?> en = a.getAttributeNames();
            while (en.hasMoreElements()) {
                Object attributeNameObj = en.nextElement();
                String attributeName = attributeNameObj.toString().toLowerCase();
                Object o = a.getAttribute(attributeNameObj);
                if (o instanceof String) {
                    String attributeValue = (String)o;
                    if (tagName.equals("a")) {
                        if (attributeName.equals("href")) {
                            this.addLink(tagName, attributeName, attributeValue, pPos, false);
                            continue;
                        }
                        if (!attributeName.equals("name")) continue;
                        this.url.addAnchor(attributeValue);
                        continue;
                    }
                    if (!tagName.equals("img") || !attributeName.equals("src")) continue;
                    this.addLink(tagName, attributeName, attributeValue, pPos, true);
                    continue;
                }
                if (o instanceof Boolean) continue;
                LinkChecker.this.handleWarning(this.url.url, pPos, "Unknown attribute type: " + (o == null ? "null" : o.getClass().getName()));
            }
            LinkChecker.this.logger.finest("URLChecker.handleTag", "<-");
        }

        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pPos) {
            super.handleSimpleTag(t, a, pPos);
            this.handleTag(t, a, pPos);
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pPos) {
            super.handleStartTag(t, a, pPos);
            this.handleTag(t, a, pPos);
        }

        public void handleError(String pErrorMsg, int pPos) {
            super.handleError(pErrorMsg, pPos);
            LinkChecker.this.handleWarning(this.url.url, pPos, "Error reported by parser: " + pErrorMsg);
        }
    }

    private class CheckedURL {
        URL url;
        URL referencingURL;
        int referencingPos;
        InputStream stream;
        boolean checkExistsOnly;
        boolean isExtern;
        private List anchors;
        private List refAnchors;

        private CheckedURL(URL pURL, URL pRefURL, int pPos) {
            this.referencingURL = pRefURL;
            this.referencingPos = pPos;
            String ref = pURL.getRef();
            String anchor = null;
            if (ref != null) {
                String s = pURL.toString();
                try {
                    if (!s.endsWith("#" + ref)) {
                        throw new MalformedURLException();
                    }
                    pURL = new URL(s.substring(0, s.length() - ref.length() - 1));
                    anchor = ref;
                }
                catch (MalformedURLException e) {
                    LinkChecker.this.handleRefError(pURL, pRefURL, pPos, "Unable to parse URL: " + pURL);
                }
            }
            this.url = pURL;
            if (anchor != null && pRefURL != null) {
                this.addAnchorRef(anchor, pRefURL, pPos);
            }
        }

        public void addAnchor(String pName) {
            if (this.anchors == null) {
                this.anchors = new ArrayList();
            }
            this.anchors.add(pName);
        }

        public void addAnchorRef(String pAnchor, URL pRefURL, int pPos) {
            AnchorReference anchorReference = new AnchorReference();
            anchorReference.name = pAnchor;
            anchorReference.ref = pRefURL;
            anchorReference.pos = pPos;
            if (this.refAnchors == null) {
                this.refAnchors = new ArrayList();
            }
            this.refAnchors.add(anchorReference);
        }

        public void validate() {
            if (this.refAnchors != null) {
                Iterator iter = this.refAnchors.iterator();
                while (iter.hasNext()) {
                    AnchorReference anchorReference = (AnchorReference)iter.next();
                    if (this.anchors != null && this.anchors.contains(anchorReference.name)) continue;
                    LinkChecker.this.handleRefError(this.url, anchorReference.ref, anchorReference.pos, "Invalid anchor: " + anchorReference.name);
                }
                this.refAnchors.clear();
            }
        }

        private class AnchorReference {
            String name;
            URL ref;
            int pos;

            private AnchorReference() {
            }
        }
    }

    private class RefEvent
    extends Event {
        private URL referencedURL;

        private RefEvent(int pSeverity, URL pURL, URL pRefURL, int pPos, String pMsg) {
            super(pSeverity, pRefURL, pPos, pMsg);
            this.referencedURL = pURL;
        }

        public String getMsg() {
            return "Failed to reference " + this.referencedURL + ": " + super.getMsg();
        }
    }

    private class Event {
        public static final int SUCCESS = 0;
        public static final int WARNING = 1;
        public static final int ERROR = 2;
        int mySeverity;
        private URL url;
        private int pos = -1;
        private String msg;

        private Event(int pSeverity, URL pURL, int pPos, String pMsg) {
            this.mySeverity = pSeverity;
            this.url = pURL;
            this.pos = pPos;
            this.msg = pMsg;
        }

        public String getMsg() {
            return this.msg;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            if (this.mySeverity == 0) {
                result.append("SUCCESS");
            } else if (this.mySeverity == 1) {
                result.append("WARNING");
            } else {
                result.append("  ERROR");
            }
            result.append(" at ").append(this.url);
            if (this.pos != -1) {
                result.append(", char ").append(this.pos);
            }
            result.append(": ").append(this.getMsg());
            return result.toString();
        }
    }
}

