/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import org.apache.ws.jaxme.sqls.BinaryColumn;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.StringColumn;
import org.apache.ws.jaxme.sqls.Table;

public abstract class AbstractColumn
implements Column,
StringColumn,
BinaryColumn {
    private final Column.Name name;
    private final Column.Type type;
    private boolean nullable;
    private Long length;
    private Object customData;

    protected AbstractColumn(Column.Name pName, Column.Type pType) {
        if (pName == null) {
            throw new NullPointerException("The column name must not be null.");
        }
        if (pType == null) {
            throw new NullPointerException("The column type must not be null.");
        }
        this.name = pName;
        this.type = pType;
    }

    public Column.Name getName() {
        return this.name;
    }

    public Column.Type getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean pNullable) {
        this.nullable = pNullable;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        Table table = this.getTable();
        if (table == null ? other.getTable() != null : !table.equals(other.getTable())) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getTable().hashCode() + this.getName().hashCode();
    }

    public boolean hasFixedLength() {
        Column.Type myType = this.getType();
        if (Column.Type.CHAR.equals(myType) || Column.Type.BINARY.equals(myType)) {
            return true;
        }
        if (Column.Type.VARCHAR.equals(myType) || Column.Type.VARBINARY.equals(myType) || Column.Type.BLOB.equals(myType) || Column.Type.OTHER.equals(myType) || Column.Type.CLOB.equals(myType)) {
            return false;
        }
        throw new IllegalStateException("Invalid data type for fixed length.");
    }

    public boolean isStringColumn() {
        Column.Type myType = this.getType();
        return Column.Type.CHAR.equals(myType) || Column.Type.VARCHAR.equals(myType) || Column.Type.CLOB.equals(myType);
    }

    public boolean isBinaryColumn() {
        Column.Type myType = this.getType();
        return Column.Type.BINARY.equals(myType) || Column.Type.VARBINARY.equals(myType) || Column.Type.BLOB.equals(myType) || Column.Type.OTHER.equals(myType);
    }

    public void setLength(Long pLength) {
        this.length = pLength;
    }

    public void setLength(long pLength) {
        this.setLength(new Long(pLength));
    }

    public Long getLength() {
        return this.length;
    }

    public Object getCustomData() {
        return this.customData;
    }

    public void setCustomData(Object pCustomData) {
        this.customData = pCustomData;
    }
}

