/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.oracle;

import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.DeleteStatement;
import org.apache.ws.jaxme.sqls.InsertStatement;
import org.apache.ws.jaxme.sqls.JoinReference;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.SelectTableReference;
import org.apache.ws.jaxme.sqls.UpdateStatement;
import org.apache.ws.jaxme.sqls.impl.SQLGeneratorImpl;
import org.apache.ws.jaxme.sqls.impl.StatementMetaData;
import org.apache.ws.jaxme.sqls.oracle.OraColumnReference;
import org.apache.ws.jaxme.sqls.oracle.OraJoinReferenceImpl;
import org.apache.ws.jaxme.sqls.oracle.OraSQLGenerator;
import org.apache.ws.jaxme.sqls.oracle.OraSelectStatement;
import org.apache.ws.jaxme.sqls.oracle.OraStatementMetaData;

public class OraSQLGeneratorImpl
extends SQLGeneratorImpl
implements OraSQLGenerator {
    private boolean isOracle8Compatibility;

    protected boolean isTableAliasUsingAs() {
        return false;
    }

    public void setOracle8Compatibility(boolean pOracle8Compatibility) {
        this.isOracle8Compatibility = pOracle8Compatibility;
    }

    public boolean isOracle8Compatibility() {
        return this.isOracle8Compatibility;
    }

    protected StatementMetaData newStatementMetaData(SelectStatement pQuery) {
        return new OraStatementMetaData(pQuery);
    }

    protected StatementMetaData newStatementMetaData(DeleteStatement pQuery) {
        return new OraStatementMetaData(pQuery);
    }

    protected StatementMetaData newStatementMetaData(UpdateStatement pQuery, ColumnReference[] pColumns) {
        return new OraStatementMetaData(pQuery, pColumns);
    }

    protected StatementMetaData newStatementMetaData(InsertStatement pQuery, ColumnReference[] pColumns) {
        return new OraStatementMetaData(pQuery, pColumns);
    }

    protected String getSelectQueryFromClause(SelectStatement pQuery, StatementMetaData pData) {
        if (this.isOracle8Compatibility()) {
            SelectTableReference tableReference = pQuery.getSelectTableReference();
            if (tableReference == null) {
                return super.getSelectQueryFromClause(pQuery, pData);
            }
            StringBuffer sb = new StringBuffer(" FROM ");
            sb.append(this.getTableAlias(pData, tableReference));
            for (JoinReference joinReference = tableReference.getRightJoinedTableReference(); joinReference != null; joinReference = joinReference.getRightJoinedTableReference()) {
                sb.append(", ");
                sb.append(this.getTableAlias(pData, joinReference));
            }
            return sb.toString();
        }
        return super.getSelectQueryFromClause(pQuery, pData);
    }

    protected String getSelectQueryConstraints(SelectStatement pQuery, StatementMetaData pData, StatementMetaData.LocalData pLocalData) {
        String result;
        if (this.isOracle8Compatibility()) {
            SelectTableReference tableReference = pQuery.getSelectTableReference();
            if (tableReference == null) {
                result = super.getSelectQuery(pQuery, pData);
            } else {
                StringBuffer sb = new StringBuffer();
                for (JoinReference joinReference = tableReference.getRightJoinedTableReference(); joinReference != null; joinReference = joinReference.getRightJoinedTableReference()) {
                    String onClause;
                    OraJoinReferenceImpl oraJoin = null;
                    if (joinReference instanceof OraJoinReferenceImpl) {
                        oraJoin = (OraJoinReferenceImpl)joinReference;
                    }
                    if (oraJoin == null) {
                        onClause = this.getWhereClause(pData, joinReference.getOn());
                    } else {
                        oraJoin.setIsOracle8LeftOuterJoin(true);
                        onClause = this.getWhereClause(pData, joinReference.getOn());
                        oraJoin.setIsOracle8LeftOuterJoin(false);
                    }
                    if (onClause == null || onClause.length() <= 0) continue;
                    if (pLocalData.hasWhereClause()) {
                        sb.append(" AND ");
                    } else {
                        pLocalData.setWhereClause(true);
                    }
                    sb.append(onClause);
                }
                String whereClause = this.getWhereClause(pData, pQuery.getWhere());
                if (whereClause != null && whereClause.length() > 0) {
                    if (pLocalData.hasWhereClause()) {
                        sb.append(" AND ");
                    } else {
                        pLocalData.setWhereClause(true);
                    }
                    sb.append(whereClause);
                }
                result = sb.toString();
            }
        } else {
            result = super.getSelectQueryConstraints(pQuery, pData, pLocalData);
        }
        if (pQuery instanceof OraSelectStatement) {
            OraSelectStatement oraStatement = (OraSelectStatement)pQuery;
            String s = this.getWhereClause(pData, oraStatement.getStartWith());
            if (s != null && s.length() > 0) {
                result = result + " START WITH " + s;
            }
            if ((s = this.getWhereClause(pData, oraStatement.getConnectBy())) != null && s.length() > 0) {
                result = result + " CONNECT BY " + s;
            }
        }
        return result;
    }

    protected String getColumnAlias(StatementMetaData pData, ColumnReference pColumn) {
        OraColumnReference oraRef;
        OraJoinReferenceImpl oraJoin;
        String s = super.getColumnAlias(pData, pColumn);
        if (pColumn.getTableReference() instanceof OraJoinReferenceImpl && (oraJoin = (OraJoinReferenceImpl)pColumn.getTableReference()).isOracle8LeftOuterJoin()) {
            s = s + "(+)";
        }
        if (pColumn instanceof OraColumnReference && (oraRef = (OraColumnReference)pColumn).isPrior()) {
            s = "PRIOR " + s;
        }
        return s;
    }

    protected String getOrderColumn(StatementMetaData pData, SelectStatement.OrderColumn pColumn) {
        OraSelectStatement.OraOrderColumn ooc;
        String s = super.getOrderColumn(pData, pColumn);
        if (pColumn instanceof OraSelectStatement.OraOrderColumn && (ooc = (OraSelectStatement.OraOrderColumn)pColumn).isNullsFirst()) {
            s = s + " NULLS FIRST";
        }
        return s;
    }
}

