/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.diagram.DiagramLink;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class DiagramLinkEditor
extends PropertyEditorSupport {
    protected JFileChooser m_FileChooser;
    private JPanel m_Panel;
    private ResourceBundle resourceBundle;

    @Override
    public String getJavaInitializationString() {
        DiagramLink fl = (DiagramLink)this.getValue();
        if (fl == null) {
            return "null";
        }
        return "new File(\"" + fl.getURL().getFile() + "\")";
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.m_Panel == null) {
            this.m_Panel = new JPanel();
            this.m_Panel.add(this.getFileChooser());
            JButton goButton = new JButton(this.getResourceBundle().getString("file.link.open.text"));
            goButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiagramLink newVal = (DiagramLink)DiagramLinkEditor.this.getValue();
                    if (newVal != null && newVal.getURL() != null) {
                        newVal.setOpenFlag(new Boolean(true));
                        DiagramLinkEditor.this.setValue(newVal);
                        DiagramLinkEditor.this.firePropertyChange();
                    }
                }
            });
            this.m_Panel.add(goButton);
        }
        return this.m_Panel;
    }

    private JFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            DiagramLink currentFileLink = (DiagramLink)this.getValue();
            if (currentFileLink != null) {
                this.m_FileChooser = new JFileChooser();
                URL url = currentFileLink.getURL();
                this.m_FileChooser.setSelectedFile(new File(url.getFile()));
            } else {
                this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
            }
            this.m_FileChooser.setDialogType(0);
            this.m_FileChooser.setFileSelectionMode(0);
            this.m_FileChooser.setFileFilter(new VioletFileFilter());
            this.m_FileChooser.setControlButtonsAreShown(false);
            this.m_FileChooser.setAcceptAllFileFilterUsed(false);
            this.m_FileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String cmdString = e.getActionCommand();
                    if (cmdString.equals("ApproveSelection")) {
                        try {
                            DiagramLink newVal = new DiagramLink();
                            newVal.setURL(DiagramLinkEditor.this.m_FileChooser.getSelectedFile().toURI().toURL());
                            DiagramLinkEditor.this.setValue(newVal);
                            DiagramLinkEditor.this.firePropertyChange();
                        }
                        catch (MalformedURLException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
        }
        return this.m_FileChooser;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        DiagramLink fl = (DiagramLink)this.getValue();
        String val = "No file";
        URL url = fl.getURL();
        if (fl != null && url != null) {
            val = url.getFile();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    private ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle("properties.OtherStrings", Locale.getDefault());
        }
        return this.resourceBundle;
    }

    private class VioletFileFilter
    extends FileFilter {
        private String fileExtension;

        private VioletFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(this.getFileExtension()) || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*" + this.getFileExtension();
        }

        private String getFileExtension() {
            if (this.fileExtension == null) {
                ResourceBundle rb = ResourceBundle.getBundle("properties.FileStrings", Locale.getDefault());
                this.fileExtension = rb.getString("files.global.extension");
            }
            return this.fileExtension;
        }
    }
}

