/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.diagram.MultiLineString;
import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MultiLineStringEditor
extends PropertyEditorSupport {
    private static final int ROWS = 5;
    private static final int COLUMNS = 30;
    private static Set<KeyStroke> tab = new HashSet<KeyStroke>(1);
    private static Set<KeyStroke> shiftTab = new HashSet<KeyStroke>(1);

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        final MultiLineString value = (MultiLineString)this.getValue();
        final JTextArea textArea = new JTextArea(5, 30);
        textArea.setFocusTraversalKeys(0, tab);
        textArea.setFocusTraversalKeys(1, shiftTab);
        textArea.setText(value.getText());
        textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                value.setText(textArea.getText());
                MultiLineStringEditor.this.firePropertyChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                value.setText(textArea.getText());
                MultiLineStringEditor.this.firePropertyChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        return new JScrollPane(textArea);
    }

    static {
        tab.add(KeyStroke.getKeyStroke("TAB"));
        shiftTab.add(KeyStroke.getKeyStroke("shift TAB"));
    }
}

