/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditorSupport;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComboBox;

public class ColorEditor
extends PropertyEditorSupport {
    private JComboBox combo = new JComboBox<ColorIcon>(colors);
    private static int[] colorValues = new int[]{0xFFFFFF, 0xFFFF00, 15132410, 11403055, 0x7FFF00, 65407, 0xFFFAFA, 16766720, 16761035, 10145074, 8190976, 64154, 0xF8F8FF, 16753920, 16758465, 0x808000, 3329330, 65280, 0xF5F5F5, 16747520, 16738740, 9419919, 0x228B22, 32768, 0xFFF5EE, 16032864, 14204888, 0x90EE90, 7048739, 25600, 0xFFFAF0, 15308410, 0xDDA0DD, 10025880, 5597999, 35723, 16643558, 16752762, 0xEE82EE, 0xF0FFF0, 3050327, 32896, 16445670, 13789470, 0xFF00FF, 0xF5FFFA, 3978097, 52945, 16119260, 16729344, 16716947, 0xF0FFFF, 6737322, 65535, 16775388, 0xB22222, 13047173, 0xE0FFFF, 2142890, 49151, 16773077, 0x8B0000, 0xCD5C5C, 0xAFEEEE, 4772300, 6591981, 16444375, 0x800000, 14381203, 11584734, 4251856, 2003199, 16772045, 0xA52A2A, 0xF08080, 0xFF00FF, 8388564, 4286945, 16770244, 10506797, 16416882, 14315734, 11591910, 6970061, 16768685, 9127187, 16744272, 9662683, 11393254, 8087790, 16770229, 12092939, 16737095, 12211667, 8900331, 255, 16113331, 14329120, 14423100, 10040012, 8900346, 205, 16767673, 13468991, 9055202, 4620980, 4734347, 0xEEE8AA, 12433259, 16770273, 9699539, 6266528, 139, 16448210, 12357519, 0xFFF0F5, 0x8B008B, 0x778899, 128, 16775885, 14596231, 0xDCDCDC, 0x800080, 7372944, 1644912, 0xFFFFE0, 13808780, 0xD3D3D3, 0xA9A9A9, 0x696969, 4915330, 0xFFFFF0, 15787660, 0xC0C0C0, 0x808080, 0x2F4F4F, 0, 0xE6E699};
    static ColorIcon[] colors = new ColorIcon[colorValues.length];

    public ColorEditor() {
        this.combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Color value = ((ColorIcon)ColorEditor.this.combo.getSelectedItem()).getColor();
                ColorEditor.this.setValue(value);
            }
        });
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        ColorIcon value = new ColorIcon((Color)this.getValue());
        int i = Arrays.binarySearch(colors, value, new ColorComparator());
        if (i < 0) {
            i = -i - 1;
        }
        this.combo.setSelectedIndex(i);
        return this.combo;
    }

    static {
        for (int i = 0; i < colorValues.length; ++i) {
            ColorEditor.colors[i] = new ColorIcon(new Color(colorValues[i]));
        }
        Arrays.sort(colors, new ColorComparator());
    }

    static class ColorComparator
    implements Comparator<ColorIcon> {
        private static float[] hsb = new float[3];

        ColorComparator() {
        }

        @Override
        public int compare(ColorIcon i1, ColorIcon i2) {
            Color c1 = i1.getColor();
            Color c2 = i2.getColor();
            Color.RGBtoHSB(c1.getRed(), c1.getGreen(), c1.getBlue(), hsb);
            float hue1 = hsb[0];
            float sat1 = hsb[1];
            float bri1 = hsb[2];
            Color.RGBtoHSB(c2.getRed(), c2.getGreen(), c2.getBlue(), hsb);
            float hue2 = hsb[0];
            float sat2 = hsb[1];
            float bri2 = hsb[2];
            if (hue1 < hue2) {
                return 1;
            }
            if (hue1 > hue2) {
                return -1;
            }
            if (sat1 < sat2) {
                return 1;
            }
            if (sat1 > sat2) {
                return -1;
            }
            if (bri1 < bri2) {
                return 1;
            }
            if (bri1 > bri2) {
                return -1;
            }
            return 0;
        }
    }

    static class ColorIcon
    implements Icon {
        private Color color;
        private static final int WIDTH = 40;
        private static final int HEIGHT = 15;

        public ColorIcon(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public int getIconWidth() {
            return 40;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Rectangle r = new Rectangle(x, y, 39, 14);
            Graphics2D g2 = (Graphics2D)g;
            Color oldColor = g2.getColor();
            g2.setColor(this.color);
            g2.fill(r);
            g2.setColor(Color.BLACK);
            g2.draw(r);
            g2.setColor(oldColor);
        }
    }
}

