/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import com.horstmann.violet.framework.action.FileAction;
import com.horstmann.violet.framework.diagram.AbstractNode;
import com.horstmann.violet.framework.diagram.ArrowHead;
import com.horstmann.violet.framework.diagram.BentStyle;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.LineStyle;
import com.horstmann.violet.framework.file.FileChooserServiceFactory;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.DiagramPanelListener;
import com.horstmann.violet.framework.gui.DialogFactory;
import com.horstmann.violet.framework.gui.WelcomePanel;
import com.horstmann.violet.framework.gui.menu.MenuFactory;
import com.horstmann.violet.framework.gui.theme.Theme;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.network.NetworkManager;
import com.horstmann.violet.framework.network.NetworkManagerListener;
import com.horstmann.violet.framework.resources.ResourceFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class EditorFrame
extends JFrame {
    private JTabbedPane tabbedPane;
    private WelcomePanel welcomePanel;
    private MenuFactory menuFactory;
    private EditorFrame editorFrame = this;
    private static HashMap<Class<?>, BeanInfo> beanInfos = new HashMap();

    public EditorFrame() {
        this.setDefaultCloseOperation(0);
        DialogFactory.getInstance().setDialogOwner(this);
        ResourceBundle resources = ResourceBundle.getBundle("properties.AboutStrings", Locale.getDefault());
        this.setTitle(resources.getString("app.name"));
        ResourceFactory resourceFactory = new ResourceFactory(resources);
        this.setIconImage(resourceFactory.createImage("app.icon"));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        this.setBounds(screenWidth / 16, screenHeight / 16, screenWidth * 7 / 8, screenHeight * 7 / 8);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                EditorFrame.this.performExit();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        menuBar.setFont(ThemeManager.getInstance().getTheme().getMENUBAR_FONT());
        MenuFactory menuFactory = this.getMenuFactory();
        menuBar.add(menuFactory.getFileMenu(this));
        menuBar.add(menuFactory.getEditMenu(this));
        menuBar.add(menuFactory.getViewMenu(this));
        menuBar.add(menuFactory.getHelpMenu(this));
        this.setJMenuBar(menuBar);
        this.getContentPane().add(this.getWelcomePanel());
        NetworkManager.getInstance().addListener(new NetworkManagerListener(){

            @Override
            public void newDiagramPanelCreated(DiagramPanel newDiagramPanel) {
                EditorFrame.this.addTabbedPane(newDiagramPanel);
            }
        });
    }

    private void performExit() {
        FileAction action = new FileAction();
        action.exit(this.getMenuFactory().getFileMenu(this), this, FileChooserServiceFactory.getInstance());
    }

    public void restart() {
        FileAction action = new FileAction();
        action.restart(this.getMenuFactory().getFileMenu(this), this, FileChooserServiceFactory.getInstance());
    }

    public void addTabbedPane(final DiagramPanel diagramPanel) {
        this.replaceWelcomePanelByTabbedPane();
        Component[] diagramPanels = this.getTabbedPane().getComponents();
        boolean isAlreadyAdded = false;
        for (int i = 0; i < diagramPanels.length; ++i) {
            DiagramPanel aDiagramPanel;
            if (!(diagramPanels[i] instanceof DiagramPanel) || (aDiagramPanel = (DiagramPanel)diagramPanels[i]).getFilePath() == null || !aDiagramPanel.getFilePath().equals(diagramPanel.getFilePath())) continue;
            isAlreadyAdded = true;
            return;
        }
        if (!isAlreadyAdded) {
            this.getTabbedPane().add(diagramPanel.getTitle(), diagramPanel);
            diagramPanel.addListener(new DiagramPanelListener(){

                @Override
                public void titleChanged(String newTitle) {
                    int pos = EditorFrame.this.getTabbedPane().indexOfComponent(diagramPanel);
                    EditorFrame.this.getTabbedPane().setTitleAt(pos, newTitle);
                }

                @Override
                public void graphCouldBeSaved() {
                }

                @Override
                public void mustOpenfile(URL url) {
                    FileAction action = new FileAction();
                    action.openURL(url, EditorFrame.this.editorFrame);
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorFrame.this.getTabbedPane().setSelectedComponent(diagramPanel);
                diagramPanel.getGraphPanel().requestFocus();
            }
        });
    }

    private void replaceWelcomePanelByTabbedPane() {
        WelcomePanel welcomePanel = this.getWelcomePanel();
        JTabbedPane tabbedPane = this.getTabbedPane();
        this.getContentPane().remove(welcomePanel);
        this.getContentPane().add(tabbedPane);
        this.repaint();
    }

    private void replaceTabbedPaneByWelcomePanel() {
        this.welcomePanel = null;
        WelcomePanel welcomePanel = this.getWelcomePanel();
        JTabbedPane tabbedPane = this.getTabbedPane();
        this.getContentPane().remove(tabbedPane);
        this.getContentPane().add(welcomePanel);
        this.repaint();
    }

    public JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    Paint currentPaint = g2.getPaint();
                    Theme LAF = ThemeManager.getInstance().getTheme();
                    GradientPaint paint = new GradientPaint(this.getWidth() / 2, -this.getHeight() / 4, LAF.getWELCOME_BACKGROUND_START_COLOR(), this.getWidth() / 2, this.getHeight() + this.getHeight() / 4, LAF.getWELCOME_BACKGROUND_END_COLOR());
                    g2.setPaint(paint);
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g2.setPaint(currentPaint);
                    super.paint(g);
                }
            };
            this.tabbedPane.setOpaque(false);
            MouseWheelListener[] mouseWheelListeners = this.tabbedPane.getMouseWheelListeners();
            for (int i = 0; i < mouseWheelListeners.length; ++i) {
                this.tabbedPane.removeMouseWheelListener(mouseWheelListeners[i]);
            }
        }
        return this.tabbedPane;
    }

    public void removeDiagramPanel(DiagramPanel diagramPanel) {
        JTabbedPane tp = this.getTabbedPane();
        tp.remove(diagramPanel);
        if (tp.getTabCount() == 0) {
            this.replaceTabbedPaneByWelcomePanel();
        }
    }

    public void setActiveDiagramPanel(String diagramFilePath) {
        if (diagramFilePath == null) {
            return;
        }
        JTabbedPane tp = this.getTabbedPane();
        Component[] components = tp.getComponents();
        for (int i = 0; i < components.length; ++i) {
            DiagramPanel dPanel;
            String filePath;
            if (!(components[i] instanceof DiagramPanel) || !diagramFilePath.equals(filePath = (dPanel = (DiagramPanel)components[i]).getFilePath())) continue;
            tp.setSelectedComponent(dPanel);
            return;
        }
    }

    public void setActiveDiagramPanel(Graph graph) {
        if (graph == null) {
            return;
        }
        JTabbedPane tp = this.getTabbedPane();
        Component[] components = tp.getComponents();
        for (int i = 0; i < components.length; ++i) {
            DiagramPanel dPanel;
            Graph aGraph;
            if (!(components[i] instanceof DiagramPanel) || !(aGraph = (dPanel = (DiagramPanel)components[i]).getGraphPanel().getGraph()).equals(graph)) continue;
            tp.setSelectedComponent(dPanel);
            return;
        }
    }

    public DiagramPanel getActiveDiagramPanel() {
        JTabbedPane tp = this.getTabbedPane();
        Component c = tp.getSelectedComponent();
        if (c instanceof DiagramPanel) {
            DiagramPanel dPanel = (DiagramPanel)c;
            return dPanel;
        }
        return null;
    }

    private WelcomePanel getWelcomePanel() {
        if (this.welcomePanel == null) {
            this.welcomePanel = new WelcomePanel(this.getMenuFactory().getFileMenu(this));
        }
        return this.welcomePanel;
    }

    public MenuFactory getMenuFactory() {
        if (this.menuFactory == null) {
            this.menuFactory = new MenuFactory();
        }
        return this.menuFactory;
    }

    static {
        Class[] cls = new Class[]{Point2D.Double.class, BentStyle.class, ArrowHead.class, LineStyle.class, Graph.class, AbstractNode.class};
        for (int i = 0; i < cls.length; ++i) {
            try {
                beanInfos.put(cls[i], Introspector.getBeanInfo(cls[i]));
                continue;
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
    }
}

