/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.menu;

import com.horstmann.violet.framework.action.ViewAction;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.EditorFrame;
import com.horstmann.violet.framework.gui.GraphPanel;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.resources.ResourceFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ViewMenu
extends JMenu {
    private EditorFrame editorFrame;
    private ResourceBundle bundle;
    private ResourceFactory factory;
    private JTabbedPane tabbedPane;
    private ViewAction viewAction;

    public ViewMenu(EditorFrame editorFrame, ResourceBundle rBundle, ResourceFactory rFactory) {
        this.editorFrame = editorFrame;
        this.tabbedPane = editorFrame.getTabbedPane();
        this.bundle = rBundle;
        this.factory = rFactory;
        this.viewAction = new ViewAction();
        this.createMenu();
    }

    private void createMenu() {
        this.factory.configureMenu(this, "view");
        JMenuItem zoomOut = this.factory.createMenuItem("view.zoom_out");
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.performZoomOut();
            }
        });
        this.add(zoomOut);
        JMenuItem zoomIn = this.factory.createMenuItem("view.zoom_in");
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.performZoomIn();
            }
        });
        this.add(zoomIn);
        JMenuItem growDrawingArea = this.factory.createMenuItem("view.grow_drawing_area");
        growDrawingArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.performGrowDrawingArea();
            }
        });
        this.add(growDrawingArea);
        JMenuItem clipDrawingArea = this.factory.createMenuItem("view.clip_drawing_area");
        clipDrawingArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.performClipDrawingArea();
            }
        });
        this.add(clipDrawingArea);
        JMenuItem smallerGrid = this.factory.createMenuItem("view.smaller_grid");
        smallerGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.performDisplaySmallerGrid();
            }
        });
        this.add(smallerGrid);
        JMenuItem largerGrid = this.factory.createMenuItem("view.larger_grid");
        largerGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.performDisplayLargerGrid();
            }
        });
        this.add(largerGrid);
        final JCheckBoxMenuItem hideGridItem = (JCheckBoxMenuItem)this.factory.createCheckBoxMenuItem("view.hide_grid");
        hideGridItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ViewMenu.this.performHideGrid(event);
            }
        });
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent event) {
                DiagramPanel diagramPanel = (DiagramPanel)ViewMenu.this.tabbedPane.getSelectedComponent();
                if (diagramPanel == null) {
                    return;
                }
                GraphPanel panel = diagramPanel.getGraphPanel();
                hideGridItem.setSelected(panel.getHideGrid());
            }

            @Override
            public void menuDeselected(MenuEvent event) {
            }

            @Override
            public void menuCanceled(MenuEvent event) {
            }
        });
        JMenu changeLookAndFeelMenu = this.factory.createMenu("view.change_laf");
        ButtonGroup lookAndFeelButtonGroup = new ButtonGroup();
        String preferedLafName = ThemeManager.getInstance().getPreferedLookAndFeel();
        UIManager.LookAndFeelInfo[] laf = ThemeManager.getInstance().getInstalledLookAndFeels();
        for (int i = 0; i < laf.length; ++i) {
            String lafName = laf[i].getName();
            final String lafClassName = laf[i].getClassName();
            JCheckBoxMenuItem lafMenu = new JCheckBoxMenuItem(lafName);
            lafMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewMenu.this.performChangeLookAndFeel(lafClassName);
                }
            });
            changeLookAndFeelMenu.add(lafMenu);
            lookAndFeelButtonGroup.add(lafMenu);
            if (!lafClassName.equals(preferedLafName)) continue;
            lafMenu.setSelected(true);
        }
        this.add(changeLookAndFeelMenu);
    }

    private void performZoomOut() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.viewAction.zoomOut(diagramPanel);
    }

    private void performZoomIn() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.viewAction.zoomIn(diagramPanel);
    }

    private void performGrowDrawingArea() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.viewAction.growDrawingArea(diagramPanel);
    }

    private void performClipDrawingArea() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.viewAction.clipDrawingArea(diagramPanel);
    }

    private void performDisplaySmallerGrid() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.viewAction.displaySmallerGrid(diagramPanel);
    }

    private void performDisplayLargerGrid() {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        this.viewAction.displayLargerGrid(diagramPanel);
    }

    private void performHideGrid(ActionEvent event) {
        DiagramPanel diagramPanel = (DiagramPanel)this.tabbedPane.getSelectedComponent();
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)event.getSource();
        boolean isHidden = menuItem.isSelected();
        this.viewAction.hideGrid(diagramPanel, isHidden);
    }

    private void performChangeLookAndFeel(String className) {
        this.viewAction.changeLookAndFeel(className, this.editorFrame, this.bundle);
    }
}

