/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.sidebar;

import com.horstmann.violet.framework.action.FileAction;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.network.NetworkAction;
import com.horstmann.violet.framework.resources.ResourceFactory;
import com.horstmann.violet.framework.swingextension.IconButtonUI;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SideShortcutOptionalPanel
extends JPanel {
    private FileAction fileAction;
    private NetworkAction networkAction;
    private DiagramPanel diagramPanel;

    public SideShortcutOptionalPanel(DiagramPanel diagramPanel, ResourceBundle sideBarResourceBundle) {
        this.diagramPanel = diagramPanel;
        this.fileAction = new FileAction();
        this.networkAction = new NetworkAction();
        this.setBackground(ThemeManager.getInstance().getTheme().getSIDEBAR_ELEMENT_BACKGROUND_COLOR());
        ResourceFactory factory = new ResourceFactory(sideBarResourceBundle);
        JButton bHelp = factory.createButton("help");
        bHelp.setUI(new IconButtonUI());
        bHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutOptionalPanel.this.performShowHelp();
            }
        });
        JButton bPrint = factory.createButton("print");
        bPrint.setUI(new IconButtonUI());
        bPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutOptionalPanel.this.performPrint();
            }
        });
        JButton bExportToClipboard = factory.createButton("export_to_clipboard");
        bExportToClipboard.setUI(new IconButtonUI());
        bExportToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutOptionalPanel.this.performExportToClipboard();
            }
        });
        JButton bShareDocument = factory.createButton("share_document");
        bShareDocument.setUI(new IconButtonUI());
        bShareDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SideShortcutOptionalPanel.this.performShareDocument();
            }
        });
        JPanel panel = new JPanel();
        GridLayout layout = new GridLayout(1, 2);
        layout.setHgap(15);
        panel.setLayout(layout);
        panel.setOpaque(false);
        panel.setBorder(new EmptyBorder(0, 5, 0, 0));
        panel.add(bExportToClipboard);
        panel.add(bPrint);
        this.setLayout(new FlowLayout(0));
        this.add(panel);
    }

    private void performShowHelp() {
    }

    private void performPrint() {
        this.fileAction.print(this.diagramPanel);
    }

    private void performExportToClipboard() {
        this.fileAction.exportToClipboard(this.diagramPanel);
    }

    private void performShareDocument() {
        this.networkAction.shareDiagramPanel(this.diagramPanel);
    }
}

