/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.theme;

import com.horstmann.violet.UMLEditor;
import com.horstmann.violet.framework.gui.theme.Theme;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import com.l2fprod.common.swing.plaf.windows.WindowsLookAndFeelAddons;
import java.awt.Frame;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public abstract class AbstractTheme
implements Theme {
    private String lafClassName;

    protected abstract String getLookAndFeelClassName();

    @Override
    public void activate() {
        try {
            this.lafClassName = this.getLookAndFeelClassName();
            UIManager.setLookAndFeel(this.lafClassName);
            Frame[] frames = Frame.getFrames();
            for (int i = 0; i < frames.length; ++i) {
                SwingUtilities.updateComponentTreeUI(frames[i]);
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            this.abortWithError(e);
        }
        catch (ClassNotFoundException e) {
            this.abortWithError(e);
        }
        catch (InstantiationException e) {
            this.abortWithError(e);
        }
        catch (IllegalAccessException e) {
            this.abortWithError(e);
        }
        this.setup();
        this.updateTaskPaneUI();
    }

    private void updateTaskPaneUI() {
        WindowsLookAndFeelAddons addons = new WindowsLookAndFeelAddons();
        LookAndFeelAddons.setAddon(addons);
        UIDefaults defaults = UIManager.getDefaults();
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("TaskPaneGroup.background", this.getSIDEBAR_ELEMENT_BACKGROUND_COLOR());
        m.put("TaskPaneGroup.titleBackgroundGradientStart", this.getSIDEBAR_ELEMENT_TITLE_BG_START_COLOR());
        m.put("TaskPaneGroup.titleBackgroundGradientEnd", this.getSIDEBAR_ELEMENT_TITLE_BG_END_COLOR());
        m.put("TaskPaneGroup.titleForeground", this.getSIDEBAR_ELEMENT_TITLE_FOREGROUND_COLOR());
        m.put("TaskPaneGroup.titleOver", this.getSIDEBAR_ELEMENT_TITLE_OVER_COLOR());
        m.put("TaskPaneGroup.borderColor", this.getSIDEBAR_ELEMENT_BACKGROUND_COLOR());
        m.put("TaskPane.useGradient", Boolean.TRUE);
        m.put("TaskPane.backgroundGradientStart", this.getSIDEBAR_BACKGROUND_START_COLOR());
        m.put("TaskPane.backgroundGradientEnd", this.getSIDEBAR_BACKGROUND_END_COLOR());
        defaults.putAll(m);
    }

    protected abstract void setup();

    private void abortWithError(Exception e) {
        System.err.println("Fatal error when loading look and feel! -> " + this.lafClassName);
        e.printStackTrace();
        System.err.println("Stopping...");
        UMLEditor.getInstance().exitWithErrors();
    }
}

