/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.network;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.network.NetworkAction;
import com.horstmann.violet.framework.network.NetworkManagerListener;
import com.horstmann.violet.framework.network.NetworkMessage;
import com.horstmann.violet.framework.network.NetworkMessageSubjectType;
import com.horstmann.violet.framework.network.NetworkSession;
import com.horstmann.violet.framework.network.receiver.IReceiver;
import com.horstmann.violet.framework.network.receiver.IReceiverListener;
import com.horstmann.violet.framework.network.receiver.MockReceiver;
import com.horstmann.violet.framework.network.receiver.ReceiverFactory;
import com.horstmann.violet.framework.network.sender.ISender;
import com.horstmann.violet.framework.network.sender.SenderFactory;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.event.EventListenerList;

public class NetworkManager {
    private static NetworkManager instance;
    private EventListenerList listeners = new EventListenerList();
    private NetworkAction action = new NetworkAction();
    private Map<DiagramPanel, NetworkSession> diagramToSessionMap = new HashMap<DiagramPanel, NetworkSession>();

    private NetworkManager() {
    }

    public static NetworkManager getInstance() {
        if (instance == null) {
            instance = new NetworkManager();
        }
        return instance;
    }

    public NetworkSession getStandardSession(String userID, URL localURL) {
        ISender sender = this.getSender(localURL);
        IReceiver receiver = this.getReceiver(localURL);
        NetworkSession session = new NetworkSession(userID, receiver, sender);
        return session;
    }

    public NetworkSession getSendingOnlySession(String userID, URL localURL) {
        ISender sender = this.getSender(localURL);
        MockReceiver receiver = new MockReceiver(localURL);
        NetworkSession session = new NetworkSession(userID, receiver, sender);
        return session;
    }

    public ISender getSender(URL senderURL) {
        return SenderFactory.getInstance().createSender(senderURL);
    }

    public IReceiver getReceiver(URL receiverURL) {
        IReceiver receiver = ReceiverFactory.getInstance().createReceiver(receiverURL);
        if (receiver.hasNoListener()) {
            receiver.addReceptionListener(new IReceiverListener(){

                @Override
                public void messageReceived(NetworkMessage msg) {
                    String subject = msg.getSubject();
                    NetworkMessageSubjectType subjectType = NetworkMessageSubjectType.parseType(subject);
                    if (subjectType.equals(NetworkMessageSubjectType.UNDEFINED)) {
                        return;
                    }
                    String senderID = msg.getFrom();
                    URL senderURL = msg.getReplyAddress();
                    String[] subjectArguments = NetworkManager.this.getMessageSubjectArguments(subject);
                    NetworkSession session = null;
                    if (subjectArguments.length > 0) {
                        String sharedDiagramId = subjectArguments[0];
                        session = NetworkManager.this.getNetworkSession(sharedDiagramId);
                    }
                    if (NetworkMessageSubjectType.REQUEST_SHARED_DIAGRAMS_LIST.equals(subjectType)) {
                        NetworkManager.this.action.sendSharedDiagramsList(senderURL);
                    } else if (NetworkMessageSubjectType.SHARED_DIAGRAMS_LIST.equals(subjectType)) {
                        SortedMap sharedDiagramsList = (SortedMap)msg.getContent();
                        NetworkManager.this.action.selectDiagramFromList(sharedDiagramsList, senderID, senderURL);
                    } else if (NetworkMessageSubjectType.REQUEST_GRAPH_REFRESH.equals(subjectType)) {
                        DiagramPanel sharedDiagramPanel = NetworkManager.this.getAttachedDiagram(session);
                        Graph graph = sharedDiagramPanel.getGraphPanel().getGraph();
                        session.addRecipient(senderID, senderURL);
                        NetworkManager.this.action.sendGraph(session, senderURL, graph);
                    } else if (NetworkMessageSubjectType.NODE_ADDED.equals(subjectType)) {
                        Node newNode = (Node)msg.getContent();
                        NetworkManager.this.action.receiveNewNode(session, newNode, senderURL);
                    } else if (NetworkMessageSubjectType.NODE_DELETED.equals(subjectType)) {
                        Node remotelyDeletedNode = (Node)msg.getContent();
                        NetworkManager.this.action.receiveDeletedNode(session, remotelyDeletedNode, senderURL);
                    } else if (NetworkMessageSubjectType.NODE_UPDATED.equals(subjectType)) {
                        Node remotelyUpdatedNode = (Node)msg.getContent();
                        NetworkManager.this.action.receiveUpdatedNode(session, remotelyUpdatedNode, senderURL);
                    } else if (NetworkMessageSubjectType.EDGE_ADDED.equals(subjectType)) {
                        Edge newEdge = (Edge)msg.getContent();
                        NetworkManager.this.action.receiveNewEdge(session, newEdge, senderURL);
                    } else if (NetworkMessageSubjectType.EDGE_UPDATED.equals(subjectType)) {
                        Edge remotelyUpdatedEdge = (Edge)msg.getContent();
                        NetworkManager.this.action.receiveUpdatedEdge(session, remotelyUpdatedEdge, senderURL);
                    } else if (NetworkMessageSubjectType.EDGE_DELETED.equals(subjectType)) {
                        Edge remotelyDeletedEdge = (Edge)msg.getContent();
                        NetworkManager.this.action.receiveDeletedEdge(session, remotelyDeletedEdge, senderURL);
                    } else if (NetworkMessageSubjectType.GRAPH_UPDATED.equals(subjectType)) {
                        Graph g = (Graph)msg.getContent();
                        NetworkManager.this.action.receiveUpdatedGraph(session, g);
                    } else if (NetworkMessageSubjectType.DISCONNECT_CLIENT.equals(subjectType)) {
                        // empty if block
                    }
                }
            });
        }
        return receiver;
    }

    public void sendMessageToRecipient(NetworkSession session, NetworkMessageSubjectType subjectType, Object content, URL recipientURL) {
        String subject = this.getPreparedMessageSubject(subjectType, session);
        String senderID = session.getSenderID();
        URL senderURL = session.getReceiver().getURL();
        ISender sender = session.getSender();
        NetworkMessage msg = new NetworkMessage(senderID, senderURL, subject, content);
        msg.addRecipient(recipientURL);
        sender.sendMessage(msg);
    }

    public void sendMessageToAll(NetworkSession session, NetworkMessageSubjectType subjectType, Object content) {
        String subject = this.getPreparedMessageSubject(subjectType, session);
        String senderID = session.getSenderID();
        URL senderURL = session.getReceiver().getURL();
        ISender sender = session.getSender();
        NetworkMessage msg = new NetworkMessage(senderID, senderURL, subject, content);
        URL[] recipientURLs = session.getRecipients();
        if (recipientURLs.length == 0) {
            return;
        }
        if (recipientURLs.length > 0) {
            for (int i = 0; i < recipientURLs.length; ++i) {
                msg.addRecipient(recipientURLs[i]);
            }
            sender.sendMessage(msg);
        }
    }

    public void sendMessageToAllExceptRecipient(NetworkSession session, NetworkMessageSubjectType subjectType, Object content, URL recipientURL) {
        String subject = this.getPreparedMessageSubject(subjectType, session);
        String senderID = session.getSenderID();
        URL senderURL = session.getReceiver().getURL();
        ISender sender = session.getSender();
        NetworkMessage msg = new NetworkMessage(senderID, senderURL, subject, content);
        URL[] recipientURLs = session.getRecipients();
        if (recipientURLs.length == 0) {
            return;
        }
        if (recipientURLs.length > 0) {
            for (int i = 0; i < recipientURLs.length; ++i) {
                if (recipientURLs[i].equals(recipientURL)) continue;
                msg.addRecipient(recipientURLs[i]);
            }
            sender.sendMessage(msg);
        }
    }

    private String getPreparedMessageSubject(NetworkMessageSubjectType subjectType, NetworkSession session) {
        ArrayList<String> args = new ArrayList<String>();
        String pattern = subjectType.getPattern();
        DiagramPanel attachedDiagram = this.getAttachedDiagram(session);
        if (attachedDiagram != null) {
            args.add(attachedDiagram.getId());
        }
        return MessageFormat.format(pattern, args.toArray());
    }

    private String[] getMessageSubjectArguments(String subject) {
        ArrayList<String> arguments = new ArrayList<String>();
        NetworkMessageSubjectType subjectType = NetworkMessageSubjectType.parseType(subject);
        MessageFormat messageFormat = new MessageFormat(subjectType.getPattern());
        try {
            Object[] objects = messageFormat.parse(subject);
            for (int i = 0; i < objects.length; ++i) {
                arguments.add(objects[i].toString());
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    public synchronized void addListener(NetworkManagerListener l) {
        this.listeners.add(NetworkManagerListener.class, l);
    }

    public void registerNewDiagramPanel(DiagramPanel newDiagramPanel) {
        NetworkManagerListener[] listeners = (NetworkManagerListener[])this.listeners.getListeners(NetworkManagerListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            NetworkManagerListener aListener = listeners[i];
            aListener.newDiagramPanelCreated(newDiagramPanel);
        }
    }

    public NetworkSession getNetworkSession(String sharedDiagramId) {
        for (DiagramPanel aDiagramPanel : this.diagramToSessionMap.keySet()) {
            if (!aDiagramPanel.getId().equals(sharedDiagramId)) continue;
            return this.diagramToSessionMap.get(aDiagramPanel);
        }
        return null;
    }

    public void attachDiagramToSession(DiagramPanel dPanel, NetworkSession session) {
        if (this.diagramToSessionMap.containsKey(dPanel)) {
            throw new RuntimeException("Diagram already atatched to a network session");
        }
        this.diagramToSessionMap.put(dPanel, session);
    }

    public DiagramPanel getAttachedDiagram(NetworkSession session) {
        for (DiagramPanel dPanel : this.diagramToSessionMap.keySet()) {
            NetworkSession aSession = this.diagramToSessionMap.get(dPanel);
            if (!aSession.equals(session)) continue;
            return dPanel;
        }
        return null;
    }

    public DiagramPanel[] getSharedDiagramPanels() {
        Set<DiagramPanel> diagramPanelSet = this.diagramToSessionMap.keySet();
        return diagramPanelSet.toArray(new DiagramPanel[diagramPanelSet.size()]);
    }
}

