/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.network;

import com.horstmann.violet.framework.diagram.AbstractEdge;
import com.horstmann.violet.framework.diagram.AbstractNode;
import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Node;
import java.awt.geom.Rectangle2D;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Statement;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class NetworkMessage
implements Serializable {
    private String from = "";
    private URL replyAddress;
    private URL[] to = new URL[0];
    private String subject = "";
    private Object content = "";

    public NetworkMessage(String from, URL replyAddress, String subject, Object content) {
        this.from = from;
        this.replyAddress = replyAddress;
        this.subject = subject;
        this.content = content;
    }

    public void addRecipient(URL recipient) {
        ArrayList<URL> recipientList = new ArrayList<URL>();
        for (int i = 0; i < this.to.length; ++i) {
            recipientList.add(this.to[i]);
        }
        if (!recipientList.contains(recipient)) {
            recipientList.add(recipient);
        }
        this.to = recipientList.toArray(new URL[recipientList.size()]);
    }

    public Object getContent() {
        return this.content;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getFrom() {
        return this.from;
    }

    public URL getReplyAddress() {
        return this.replyAddress;
    }

    public URL[] getTo() {
        return this.to;
    }

    public static void setPersistenceDelegate(Encoder encoder) {
        encoder.setPersistenceDelegate(NetworkMessage.class, new DefaultPersistenceDelegate(new String[]{"from", "replyAddress", "subject", "content"}));
        encoder.setPersistenceDelegate(AbstractNode.class, new DefaultPersistenceDelegate(){

            @Override
            protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
                super.initialize(type, oldInstance, newInstance, out);
                Node n = (Node)oldInstance;
                List<Node> children = n.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    Node c = children.get(i);
                    out.writeStatement(new Statement(oldInstance, "addChild", new Object[]{c}));
                }
                Rectangle2D bounds = n.getBounds();
                out.writeStatement(new Statement(oldInstance, "setBounds", new Object[]{bounds}));
                String id = n.getId();
                out.writeStatement(new Statement(oldInstance, "setId", new Object[]{id}));
                Integer revision = n.getRevision();
                out.writeStatement(new Statement(oldInstance, "setRevision", new Object[]{revision}));
            }
        });
        encoder.setPersistenceDelegate(AbstractEdge.class, new DefaultPersistenceDelegate(){

            @Override
            protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
                super.initialize(type, oldInstance, newInstance, out);
                Edge e = (Edge)oldInstance;
                Node startNode = e.getStart();
                Node endNode = e.getEnd();
                out.writeStatement(new Statement(oldInstance, "connect", new Object[]{startNode, endNode}));
                String id = e.getId();
                out.writeStatement(new Statement(oldInstance, "setId", new Object[]{id}));
                Integer revision = e.getRevision();
                out.writeStatement(new Statement(oldInstance, "setRevision", new Object[]{revision}));
            }
        });
    }
}

